/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.dialogs;

import java.util.Vector;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rse.ui.RSEUIPlugin;

public class SystemSimpleContentElement {
    private String name;
    private Object data;
    private SystemSimpleContentElement parent;
    private SystemSimpleContentElement[] children;
    private ImageDescriptor imageDescriptor;
    private boolean selected = false;
    private boolean isDeletable = true;
    private boolean isRenamable = true;
    private boolean isReadonly = false;

    public SystemSimpleContentElement(String name, Object data, SystemSimpleContentElement parent, SystemSimpleContentElement[] children) {
        this.setName(name);
        this.setData(data);
        this.setParent(parent);
        this.setChildren(children);
    }

    public SystemSimpleContentElement(String name, Object data, SystemSimpleContentElement parent, Vector children) {
        this.setName(name);
        this.setData(data);
        this.setParent(parent);
        this.setChildren(children);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public SystemSimpleContentElement getParent() {
        return this.parent;
    }

    public void setParent(SystemSimpleContentElement parent) {
        this.parent = parent;
    }

    public SystemSimpleContentElement getRoot() {
        SystemSimpleContentElement currParent = this.parent;
        while (currParent.getParent() != null) {
            currParent = currParent.getParent();
        }
        return currParent;
    }

    public SystemSimpleContentElement[] getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return this.children != null && this.children.length > 0;
    }

    public void setChildren(SystemSimpleContentElement[] children) {
        this.children = children;
    }

    public void setChildren(Vector childrenVector) {
        if (childrenVector != null) {
            this.children = new SystemSimpleContentElement[childrenVector.size()];
            int idx = 0;
            while (idx < childrenVector.size()) {
                this.children[idx] = (SystemSimpleContentElement)childrenVector.elementAt(idx);
                ++idx;
            }
        } else {
            this.children = null;
        }
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setRenamable(boolean renamable) {
        this.isRenamable = renamable;
    }

    public boolean isRenamable() {
        return this.isRenamable;
    }

    public void setDeletable(boolean deletable) {
        this.isDeletable = deletable;
    }

    public boolean isDeletable() {
        return this.isDeletable;
    }

    public void setReadOnly(boolean readonly) {
        this.isReadonly = readonly;
    }

    public boolean isReadOnly() {
        return this.isReadonly;
    }

    public void setImageDescriptor(ImageDescriptor imageDescriptor) {
        this.imageDescriptor = imageDescriptor;
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.imageDescriptor != null) {
            return this.imageDescriptor;
        }
        return RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemfolderIcon");
    }

    public void deleteChild(SystemSimpleContentElement child) {
        if (this.children != null) {
            int nbrChildren = this.children.length;
            if (nbrChildren == 1 && child.equals(this.children[0])) {
                this.children = null;
            } else {
                SystemSimpleContentElement[] newChildren = new SystemSimpleContentElement[nbrChildren - 1];
                int newIdx = 0;
                int idx = 0;
                while (idx < this.children.length) {
                    if (!this.children[idx].equals(child)) {
                        newChildren[newIdx++] = this.children[idx];
                    }
                    ++idx;
                }
                this.children = newChildren;
            }
        }
    }

    public void addChild(SystemSimpleContentElement child, int pos) {
        if (this.children == null) {
            this.children = new SystemSimpleContentElement[1];
            this.children[0] = child;
        } else {
            int newNbr = this.children.length + 1;
            SystemSimpleContentElement[] newChildren = new SystemSimpleContentElement[newNbr];
            int oldIdx = 0;
            int idx = 0;
            while (idx < newNbr) {
                newChildren[idx] = idx == pos ? child : this.children[oldIdx++];
                ++idx;
            }
            this.children = newChildren;
        }
    }

    public String toString() {
        return this.getName();
    }

    public static SystemSimpleContentElement getDataElement(SystemSimpleContentElement root, Object data) {
        int idx;
        SystemSimpleContentElement[] children = root.getChildren();
        SystemSimpleContentElement match = null;
        if (children != null && children.length > 0) {
            idx = 0;
            while (match == null && idx < children.length) {
                if (children[idx].getData() == data) {
                    match = children[idx];
                }
                ++idx;
            }
        }
        if (match == null && children != null && children.length > 0) {
            idx = 0;
            while (match == null && idx < children.length) {
                match = SystemSimpleContentElement.getDataElement(children[idx], data);
                ++idx;
            }
        }
        return match;
    }
}

