/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.tar;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.eclipse.php.internal.core.tar.CRCable;

public class GZIPOutputStreamForPhar
extends DeflaterOutputStream
implements CRCable {
    protected CRC32 crc = new CRC32();
    private boolean closed = false;

    public GZIPOutputStreamForPhar(OutputStream out, int size) throws IOException {
        super(out, new Deflater(-1, true), size);
        this.crc.reset();
    }

    public GZIPOutputStreamForPhar(OutputStream out) throws IOException {
        this(out, 512);
    }

    @Override
    public synchronized void write(byte[] buf, int off, int len) throws IOException {
        super.write(buf, off, len);
        this.crc.update(buf, off, len);
    }

    @Override
    public void finish() throws IOException {
        if (!this.def.finished()) {
            this.def.finish();
            while (!this.def.finished()) {
                int len = this.def.deflate(this.buf, 0, this.buf.length);
                if (len <= 0) continue;
                this.out.write(this.buf, 0, len);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.finish();
            this.def.end();
            this.out.close();
            this.closed = true;
        }
    }

    @Override
    public long getCrc() {
        return this.crc.getValue();
    }
}

