/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.container;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.net4j.util.container.PersistableContainer;

public class SetContainer<E>
extends PersistableContainer<E> {
    private final Set<E> set;

    public SetContainer(Class<E> componentType) {
        this(componentType, new HashSet());
    }

    public SetContainer(Class<E> componentType, Set<E> set) {
        super(componentType);
        this.set = set;
    }

    protected Set<E> getSet() {
        return this.set;
    }

    @Override
    protected boolean backingStoreIsEmpty() {
        return this.set.isEmpty();
    }

    @Override
    protected int backingStoreSize() {
        return this.set.size();
    }

    @Override
    protected E[] backingStoreToArray(E[] a) {
        return this.set.toArray(a);
    }

    @Override
    protected void backingStoreForEach(Consumer<E> consumer) {
        if (consumer != null) {
            for (E element : this.set) {
                consumer.accept(element);
            }
        }
    }

    @Override
    protected boolean backingStoreContains(E element) {
        return this.set.contains(element);
    }

    @Override
    protected boolean backingStoreAdd(E element) {
        return this.set.add(element);
    }

    @Override
    protected boolean backingStoreRemove(E element) {
        return this.set.remove(element);
    }

    @Override
    protected void backingStoreClear() {
        this.set.clear();
    }
}

