/*
 * Copyright (c) 2013, 2015, 2019 Eike Stepper (Loehne, Germany) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    Eike Stepper - initial API and implementation
 */
package org.eclipse.net4j.spi.db.ddl;

import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBIndexField;

/**
 * @since 4.2
 * @author Eike Stepper
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 */
public interface InternalDBIndex extends IDBIndex, InternalDBSchemaElement
{
  public static final IDBIndexField[] NO_INDEX_FIELDS = {};

  @Override
  public IDBIndex getWrapper();

  public void removeIndexField(IDBIndexField indexFieldToRemove);

  /**
   * @since 4.5
   */
  public boolean isOptional();

  /**
   * @since 4.5
   */
  public void setOptional(boolean optional);
}
