/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.layout;

import java.util.List;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.layout.CSSBlockFlowLayout;
import org.eclipse.jst.pagedesigner.css2.layout.CSSFigure;
import org.eclipse.jst.pagedesigner.css2.layout.ICSSPainter;
import org.eclipse.jst.pagedesigner.css2.layout.LineBox;
import org.eclipse.jst.pagedesigner.css2.list.CounterHelper;
import org.eclipse.jst.pagedesigner.css2.list.ICounterValueGenerator;
import org.eclipse.jst.pagedesigner.css2.marker.CounterUtil;
import org.eclipse.jst.pagedesigner.css2.style.DefaultStyle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class CSSListItemLayout
extends CSSBlockFlowLayout
implements ICSSPainter {
    private static final String DEFAULT_LIST_COUNTER = "_anonymous";
    private static final int CIRCLE_DIAMETER = 6;
    private static final int DISC_DIAMETER = 5;
    private static final int ROUNDRECT_ARC = 2;
    private static final int TEXT_PADDING = 16;
    private int _count;

    public CSSListItemLayout(CSSFigure cssfigure) {
        super(cssfigure);
    }

    @Override
    public void paintFigure(Graphics g) {
        ICSSStyle style = this.getCSSStyle();
        if (style == null) {
            style = DefaultStyle.getInstance();
        }
        Rectangle drawArea = null;
        Font font = this.getCSSStyle().getCSSFont().getSwtFont();
        Object styleType = style.getStyleProperty("list-style-type");
        g.pushState();
        Color newColor = null;
        Object color = style.getColor();
        if (color instanceof Color) {
            g.setForegroundColor((Color)color);
            g.setBackgroundColor((Color)color);
        } else if (color instanceof RGB) {
            newColor = new Color((Device)Display.getCurrent(), (RGB)color);
            g.setForegroundColor(newColor);
            g.setBackgroundColor(newColor);
        }
        if (styleType instanceof String) {
            int type = CounterHelper.toTypeInt((String)styleType);
            switch (type) {
                case 17: 
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    g.setFont(font);
                    String displayString = CounterUtil.convertCount(this._count, type);
                    Point point = this.getDrawPointForText(displayString);
                    g.drawString(displayString, point);
                    break;
                }
                case 2: {
                    drawArea = this.getDrawAreaForGraph(6, 6);
                    g.drawArc(drawArea, 0, 360);
                    break;
                }
                case 3: {
                    drawArea = this.getDrawAreaForGraph(5, 5);
                    g.fillRectangle(drawArea);
                }
                default: {
                    drawArea = this.getDrawAreaForGraph(5, 5);
                    g.fillRoundRectangle(drawArea, 2, 2);
                }
            }
        }
        g.popState();
        if (newColor != null) {
            newColor.dispose();
        }
    }

    private Rectangle getDrawAreaForGraph(int width, int height) {
        int x = 0;
        int y = 0;
        List list = this._blockBox.getFragments();
        Rectangle box = this._blockBox.toRectangle().getCopy().expand(this._blockBox.getBorderPaddingInsets().getAdded(this._blockBox.getMarginInsets()));
        if (list != null && !list.isEmpty()) {
            LineBox line = (LineBox)list.get(0);
            y = line.getBaseline() - 6;
            x = box.x;
        } else {
            x = box.x;
            y = box.height / 2 - 6;
        }
        Rectangle drawArea = new Rectangle(x - 15, y, width, height);
        return drawArea;
    }

    private Point getDrawPointForText(String displayString) {
        Font font = this.getCSSStyle().getCSSFont().getSwtFont();
        int x = 0;
        int y = 0;
        Rectangle box = this._blockBox.toRectangle().getCopy().expand(this._blockBox.getBorderPaddingInsets().getAdded(this._blockBox.getMarginInsets()));
        x = box.x - FigureUtilities.getTextWidth((String)displayString, (Font)font);
        return new Point(x -= 16 - FigureUtilities.getFontMetrics((Font)font).getDescent(), y);
    }

    @Override
    protected void layoutChildren() {
        ICounterValueGenerator counter = this.getCSSStyle().findCounter(DEFAULT_LIST_COUNTER, true);
        this._count = counter != null ? counter.getCurrentCount() : 1;
        super.layoutChildren();
    }
}

