/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.validation;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.validation.AbstractInjectableValidator;
import org.eclipse.xtext.validation.CancelableDiagnostician;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.validation.ResourceValidatorImpl;
import org.eclipse.xtext.validation.impl.ConcreteSyntaxEValidator;
import org.eclipse.xtext.xbase.annotations.validation.DerivedStateAwareResourceValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XcoreResourceValidator
extends DerivedStateAwareResourceValidator {
    private static final Logger log = LoggerFactory.getLogger(ResourceValidatorImpl.class);
    @Inject
    private Diagnostician diagnostician;
    @Inject
    private OperationCanceledManager operationCanceledManager;

    protected void validate(Resource resource, CheckMode mode, CancelIndicator monitor, IAcceptor<Issue> acceptor) {
        ResourceSet resourceSet = resource.getResourceSet();
        BasicDiagnostic resourceSetDiagnostic = new BasicDiagnostic("org.eclipse.emf.ecore", 0, null, new Object[]{resourceSet});
        BasicDiagnostic resourceDiagnostic = new BasicDiagnostic("org.eclipse.emf.ecore", 0, null, new Object[]{resource});
        resourceSetDiagnostic.add((Diagnostic)resourceDiagnostic);
        for (EObject eObject : resource.getContents()) {
            if (monitor.isCanceled()) {
                return;
            }
            if (eObject instanceof JvmIdentifiableElement) break;
            resourceDiagnostic.add(this.validateElement(resource, eObject, mode, monitor, acceptor));
        }
        for (Adapter adapter : resourceSet.eAdapters()) {
            if (!(adapter instanceof ValidationAdapter)) continue;
            ValidationAdapter validationAdapter = (ValidationAdapter)adapter;
            validationAdapter.update((Diagnostic)resourceSetDiagnostic);
        }
    }

    protected Diagnostic validateElement(Resource resource, EObject element, CheckMode mode, CancelIndicator monitor, IAcceptor<Issue> acceptor) {
        try {
            Diagnostic diagnostic;
            HashMap options = Maps.newHashMap();
            options.put("check.mode", mode);
            options.put(CancelableDiagnostician.CANCEL_INDICATOR, monitor);
            options.put(ConcreteSyntaxEValidator.DISABLE_CONCRETE_SYNTAX_EVALIDATOR, Boolean.TRUE);
            options.put(EValidator.class, this.diagnostician);
            if (resource instanceof XtextResource) {
                options.put(AbstractInjectableValidator.CURRENT_LANGUAGE_NAME, ((XtextResource)resource).getLanguageName());
            }
            if (!(diagnostic = this.diagnostician.validate(element, (Map)options)).getChildren().isEmpty()) {
                for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                    this.issueFromEValidatorDiagnostic(childDiagnostic, acceptor);
                }
            } else {
                this.issueFromEValidatorDiagnostic(diagnostic, acceptor);
            }
            return diagnostic;
        }
        catch (RuntimeException e) {
            this.operationCanceledManager.propagateAsErrorIfCancelException((Throwable)e);
            log.error(e.getMessage(), (Throwable)e);
            return Diagnostic.OK_INSTANCE;
        }
    }

    public static abstract class ValidationAdapter
    extends AdapterImpl {
        public abstract void update(Diagnostic var1);
    }
}

