/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.scoping.types;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;

public abstract class AbstractXcoreScope
implements IScope {
    public IEObjectDescription getSingleElement(QualifiedName name) {
        throw new UnsupportedOperationException();
    }

    public Iterable<IEObjectDescription> getElements(QualifiedName name) {
        throw new UnsupportedOperationException();
    }

    public IEObjectDescription getSingleElement(EObject object) {
        Iterator<IEObjectDescription> elements = this.getElements(object).iterator();
        if (elements.hasNext()) {
            IEObjectDescription result = elements.next();
            String resultName = result.getName().toString();
            while (elements.hasNext()) {
                int resultNameLength;
                IEObjectDescription candidate = elements.next();
                String candidateName = candidate.getName().toString();
                int candidateNameLength = candidateName.length();
                if (candidateNameLength < (resultNameLength = resultName.length())) {
                    result = candidate;
                    resultName = candidateName;
                    continue;
                }
                if (candidateNameLength != resultNameLength || candidate.getQualifiedName().getSegmentCount() <= result.getQualifiedName().getSegmentCount()) continue;
                result = candidate;
                resultName = candidateName;
            }
            return result;
        }
        return null;
    }

    public final Iterable<IEObjectDescription> getElements(EObject object) {
        if (!(object instanceof JvmType) || object.eIsProxy()) {
            throw new IllegalArgumentException(String.valueOf(object));
        }
        LinkedList result = Lists.newLinkedList();
        this.doGetElements((JvmType)object, result);
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            IEObjectDescription description = (IEObjectDescription)iterator.next();
            IEObjectDescription lookUp = this.getSingleElement(description.getName());
            if (lookUp != null && lookUp.getEObjectOrProxy() == object) continue;
            iterator.remove();
        }
        return result;
    }

    protected abstract void doGetElements(JvmType var1, List<IEObjectDescription> var2);

    public Iterable<IEObjectDescription> getAllElements() {
        throw new UnsupportedOperationException();
    }
}

