/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;

public final class CDOCrossReferenceAdapter
extends ECrossReferenceAdapter {
    public void setTarget(Notifier target) {
        if (target instanceof Resource) {
            super.setTarget((Resource)target);
        } else if (target instanceof EObject) {
            super.setTarget((EObject)target);
        } else if (target instanceof ResourceSet) {
            super.setTarget((ResourceSet)target);
        }
    }

    public void unsetTarget(Notifier target) {
        if (target instanceof Resource) {
            super.unsetTarget((Resource)target);
        } else if (target instanceof EObject) {
            super.unsetTarget((EObject)target);
        } else if (target instanceof ResourceSet) {
            super.unsetTarget((ResourceSet)target);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void selfAdapt(Notification notification) {
        Object notifier = notification.getNotifier();
        if (notifier instanceof Resource) {
            switch (notification.getFeatureID(Resource.class)) {
                case 2: {
                    if (this.unloadedResources.contains(notifier)) return;
                    switch (notification.getEventType()) {
                        case 4: {
                            Resource resource = (Resource)notifier;
                            if (resource.isLoaded()) return;
                            EObject eObject = (EObject)notification.getOldValue();
                            this.unloadedEObjects.put(eObject, resource);
                            TreeIterator i = EcoreUtil.getAllProperContents((EObject)eObject, (boolean)false);
                            while (i.hasNext()) {
                                this.unloadedEObjects.put((EObject)i.next(), resource);
                            }
                            return;
                        }
                        case 6: {
                            Resource resource = (Resource)notifier;
                            if (resource.isLoaded()) return;
                            List eObjects = (List)notification.getOldValue();
                            TreeIterator i = EcoreUtil.getAllProperContents((Collection)eObjects, (boolean)false);
                            while (i.hasNext()) {
                                this.unloadedEObjects.put((EObject)i.next(), resource);
                            }
                            return;
                        }
                        default: {
                            this.handleContainment(notification);
                            return;
                        }
                    }
                }
                case 4: {
                    if (notification.getNewBooleanValue()) {
                        this.unloadedResources.remove(notifier);
                        for (Notifier child : ((Resource)notifier).getContents()) {
                            this.addAdapter(child);
                        }
                        return;
                    }
                    this.unloadedResources.add((Resource)notifier);
                    Iterator i = this.unloadedEObjects.entrySet().iterator();
                    while (i.hasNext()) {
                        EObject eObject;
                        Collection settings;
                        Map.Entry entry = i.next();
                        if (entry.getValue() != notifier) continue;
                        i.remove();
                        if (this.resolve() || (settings = (Collection)this.inverseCrossReferencer.get((Object)(eObject = (EObject)entry.getKey()))) == null) continue;
                        for (EStructuralFeature.Setting setting : settings) {
                            this.getInverseCrossReferencer().addProxy(eObject, setting.getEObject());
                        }
                    }
                }
                default: {
                    return;
                }
            }
        }
        if (notifier instanceof EObject) {
            Object feature = notification.getFeature();
            if (!(feature instanceof EReference)) return;
            EReference reference = (EReference)feature;
            if (reference.isContainment()) {
                this.handleContainment(notification);
                return;
            } else {
                if (!this.isIncluded(reference)) return;
                this.handleCrossReference(reference, notification);
            }
            return;
        } else {
            if (!(notifier instanceof ResourceSet) || notification.getFeatureID(ResourceSet.class) != 0) return;
            this.handleContainment(notification);
        }
    }

    protected CDOInverseCrossReferencer createInverseCrossReferencer() {
        return new CDOInverseCrossReferencer();
    }

    protected CDOInverseCrossReferencer getInverseCrossReferencer() {
        return (CDOInverseCrossReferencer)this.inverseCrossReferencer;
    }

    protected class CDOInverseCrossReferencer
    extends ECrossReferenceAdapter.InverseCrossReferencer {
        private static final long serialVersionUID = 1L;

        protected CDOInverseCrossReferencer() {
            super((ECrossReferenceAdapter)CDOCrossReferenceAdapter.this);
        }

        protected void addProxy(EObject proxy, EObject context) {
            super.addProxy(proxy, context);
        }
    }
}

