/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.ui.widgets;

import java.util.Objects;
import org.eclipse.emf.cdo.lm.Baseline;
import org.eclipse.emf.cdo.lm.ui.bundle.OM;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.collection.ConcurrentArray;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class BaselineComposite
extends Composite {
    private static BaselineSelectorContributor[] selectors = new BaselineSelectorContributor[]{new BaselineSelectorContributor(){

        @Override
        public boolean contributeBaselineSelector(final BaselineComposite composite, Object context) {
            Button button = new Button((Composite)composite, 8);
            button.setLayoutData((Object)GridDataFactory.fillDefaults().create());
            button.setText("Latest");
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EList<Baseline> choiceOfValues = composite.getChoiceOfValues();
                    composite.setBaseline(choiceOfValues.isEmpty() ? null : (Baseline)choiceOfValues.get(0));
                }
            });
            return true;
        }
    }};
    private ConcurrentArray<ModifyListener> listeners = new ConcurrentArray<ModifyListener>(){

        protected ModifyListener[] newArray(int length) {
            return new ModifyListener[length];
        }
    };
    private final EList<Baseline> choiceOfValues;
    private Baseline baseline;
    private boolean settingValue;
    private ComboViewer viewer;

    public BaselineComposite(Composite parent, int style, EList<Baseline> choiceOfValues, Object context) {
        super(parent, style);
        this.choiceOfValues = new BasicEList(choiceOfValues);
        this.choiceOfValues.sort(Baseline.COMPARATOR);
        this.viewer = new ComboViewer((Composite)this, 2052);
        this.viewer.getControl().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).create());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return BaselineComposite.this.getText((Baseline)element);
            }
        });
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setInput(this.choiceOfValues);
        this.viewer.addSelectionChangedListener(event -> {
            if (!this.settingValue) {
                Baseline oldBaseline = this.baseline;
                this.baseline = (Baseline)event.getStructuredSelection().getFirstElement();
                this.notifyModifyListeners(oldBaseline);
            }
        });
        int columns = 1;
        if (context != null) {
            int i = 0;
            while (i < selectors.length) {
                BaselineSelectorContributor selector = selectors[i];
                if (selector.contributeBaselineSelector(this, context)) {
                    ++columns;
                }
                ++i;
            }
        }
        this.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(columns).create());
    }

    public EList<Baseline> getChoiceOfValues() {
        return this.choiceOfValues;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        UIUtil.forEachChild((Composite)this, c -> c.setEnabled(enabled));
    }

    public void addModifyListener(ModifyListener listener) {
        CheckUtil.checkArg((Object)listener, (String)"listener");
        this.listeners.add((Object)listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        CheckUtil.checkArg((Object)listener, (String)"listener");
        this.listeners.remove((Object)listener);
    }

    public Baseline getBaseline() {
        return this.baseline;
    }

    public void setBaseline(Baseline newBaseline) {
        if (!Objects.equals(this.baseline, newBaseline)) {
            Baseline oldBaseline = this.baseline;
            this.baseline = newBaseline;
            if (!this.viewer.getControl().isDisposed()) {
                try {
                    this.settingValue = true;
                    this.viewer.setSelection((ISelection)new StructuredSelection((Object)this.baseline));
                }
                finally {
                    this.settingValue = false;
                }
            }
            this.notifyModifyListeners(oldBaseline);
        }
    }

    protected String getText(Baseline baseline) {
        return baseline.getTypeAndName();
    }

    private void notifyModifyListeners(Baseline oldValue) {
        if (!Objects.equals(this.baseline, oldValue)) {
            ModifyListener[] array = (ModifyListener[])this.listeners.get();
            int i = 0;
            while (i < array.length) {
                try {
                    ModifyListener listener = array[i];
                    if (listener != null) {
                        listener.modifyBaseline(this, this.baseline);
                    }
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
                ++i;
            }
        }
    }

    @FunctionalInterface
    public static interface BaselineSelectorContributor {
        public boolean contributeBaselineSelector(BaselineComposite var1, Object var2);
    }

    @FunctionalInterface
    public static interface ModifyListener {
        public void modifyBaseline(BaselineComposite var1, Baseline var2);
    }
}

