/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cn.smart.hhmm;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.cn.smart.hhmm.SegToken;
import org.apache.lucene.internal.hppc.IntObjectHashMap;

class SegGraph {
    private IntObjectHashMap<ArrayList<SegToken>> tokenListTable = new IntObjectHashMap();
    private int maxStart = -1;

    SegGraph() {
    }

    public boolean isStartExist(int s) {
        return this.tokenListTable.get(s) != null;
    }

    public List<SegToken> getStartList(int s) {
        return (List)this.tokenListTable.get(s);
    }

    public int getMaxStart() {
        return this.maxStart;
    }

    public List<SegToken> makeIndex() {
        ArrayList<SegToken> result = new ArrayList<SegToken>();
        int s = -1;
        int count = 0;
        int size = this.tokenListTable.size();
        int index = 0;
        while (count < size) {
            if (this.isStartExist(s)) {
                List tokenList = (List)this.tokenListTable.get(s);
                for (SegToken st : tokenList) {
                    st.index = index++;
                    result.add(st);
                }
                ++count;
            }
            ++s;
        }
        return result;
    }

    public void addToken(SegToken token) {
        int s = token.startOffset;
        if (!this.isStartExist(s)) {
            ArrayList<SegToken> newlist = new ArrayList<SegToken>();
            newlist.add(token);
            this.tokenListTable.put(s, newlist);
        } else {
            List tokenList = (List)this.tokenListTable.get(s);
            tokenList.add(token);
        }
        if (s > this.maxStart) {
            this.maxStart = s;
        }
    }

    public List<SegToken> toTokenList() {
        ArrayList<SegToken> result = new ArrayList<SegToken>();
        int s = -1;
        int count = 0;
        int size = this.tokenListTable.size();
        while (count < size) {
            if (this.isStartExist(s)) {
                List tokenList = (List)this.tokenListTable.get(s);
                for (SegToken st : tokenList) {
                    result.add(st);
                }
                ++count;
            }
            ++s;
        }
        return result;
    }

    public String toString() {
        List<SegToken> tokenList = this.toTokenList();
        StringBuilder sb = new StringBuilder();
        for (SegToken t : tokenList) {
            sb.append(t).append("\n");
        }
        return sb.toString();
    }
}

