/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.core.internal.model;

import org.eclipse.wst.xsl.core.internal.model.StylesheetParserData;
import org.eclipse.wst.xsl.core.model.CallTemplate;
import org.eclipse.wst.xsl.core.model.Function;
import org.eclipse.wst.xsl.core.model.Import;
import org.eclipse.wst.xsl.core.model.Include;
import org.eclipse.wst.xsl.core.model.Parameter;
import org.eclipse.wst.xsl.core.model.Template;
import org.eclipse.wst.xsl.core.model.Variable;
import org.eclipse.wst.xsl.core.model.XSLElement;
import org.eclipse.wst.xsl.core.model.XSLModelObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XSLElementFactory {
    private StylesheetParserData stylesheetParserData;
    private Element element;

    public XSLElementFactory(StylesheetParserData data, Element element) {
        this.stylesheetParserData = data;
        this.element = element;
    }

    public XSLElement createStyleSheet() {
        String version = this.element.getAttribute("version");
        this.stylesheetParserData.getStylesheet().setVersion(version);
        return this.stylesheetParserData.getStylesheet();
    }

    public XSLElement createInclude() {
        Include include = new Include(this.stylesheetParserData.getStylesheet());
        this.stylesheetParserData.getStylesheet().addInclude(include);
        return include;
    }

    public XSLElement createImport() {
        Import include = new Import(this.stylesheetParserData.getStylesheet());
        this.stylesheetParserData.getStylesheet().addImport(include);
        return include;
    }

    public XSLElement createTemplate() {
        this.stylesheetParserData.setCurrentTemplate(new Template(this.stylesheetParserData.getStylesheet()));
        this.stylesheetParserData.getStylesheet().addTemplate(this.stylesheetParserData.getCurrentTemplate());
        return this.stylesheetParserData.getCurrentTemplate();
    }

    public XSLElement createParamater() {
        Parameter param = new Parameter(this.stylesheetParserData.getStylesheet());
        NodeList childNodes = this.element.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 2) {
                param.setValue(true);
                break;
            }
            ++i;
        }
        if (this.stylesheetParserData.getParentEl() != null) {
            if (this.stylesheetParserData.getParentEl().getModelType() == XSLModelObject.Type.FUNCTION) {
                Function function = (Function)this.stylesheetParserData.getParentEl();
                function.addParameter(param);
            } else if (this.stylesheetParserData.getParentEl().getModelType() == XSLModelObject.Type.TEMPLATE && this.stylesheetParserData.getElementStack().size() == 2 && this.stylesheetParserData.getCurrentTemplate() != null) {
                Template template = (Template)this.stylesheetParserData.getParentEl();
                template.addParameter(param);
            }
        }
        return param;
    }

    public XSLElement createCallTemplate() {
        CallTemplate currentCallTemplate = new CallTemplate(this.stylesheetParserData.getStylesheet());
        this.stylesheetParserData.getCallTemplates().push(currentCallTemplate);
        this.stylesheetParserData.getStylesheet().addCalledTemplate(currentCallTemplate);
        return currentCallTemplate;
    }

    public XSLElement createWithParamParm() {
        Parameter param = new Parameter(this.stylesheetParserData.getStylesheet());
        NodeList childNodes = this.element.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 2) {
                param.setValue(true);
                break;
            }
            ++i;
        }
        CallTemplate currentCallTemplate = this.stylesheetParserData.getCallTemplates().peek();
        currentCallTemplate.addParameter(param);
        return param;
    }

    public XSLElement createVariable(XSLElement xslEl) {
        if (this.stylesheetParserData.getElementStack().size() == 1) {
            Variable var = new Variable(this.stylesheetParserData.getStylesheet());
            this.stylesheetParserData.getStylesheet().addGlobalVariable(var);
            xslEl = var;
        } else if (this.stylesheetParserData.getElementStack().size() > 1 && this.stylesheetParserData.getCurrentTemplate() != null) {
            Variable var = new Variable(this.stylesheetParserData.getStylesheet());
            this.stylesheetParserData.getCurrentTemplate().addVariable(var);
            xslEl = var;
        }
        return xslEl;
    }

    public XSLElement createFunction() {
        this.stylesheetParserData.setCurrentTemplate(null);
        Function function = new Function(this.stylesheetParserData.getStylesheet());
        this.stylesheetParserData.getFunctions().push(function);
        this.stylesheetParserData.getStylesheet().addFunction(function);
        return function;
    }

    public XSLElement createXSLElement() {
        return new XSLElement(this.stylesheetParserData.getStylesheet());
    }
}

