/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.ui.internal.text.hover;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.wst.json.core.document.IJSONNode;
import org.eclipse.wst.json.core.document.IJSONPair;
import org.eclipse.wst.json.core.document.IJSONValue;
import org.eclipse.wst.json.core.util.JSONUtil;
import org.eclipse.wst.json.ui.internal.Logger;
import org.eclipse.wst.json.ui.internal.text.JSONBrowserInformationControlInput;
import org.eclipse.wst.json.ui.internal.text.JSONHoverControlCreator;
import org.eclipse.wst.json.ui.internal.text.JSONPresenterControlCreator;
import org.eclipse.wst.json.ui.internal.text.hover.HTMLJSONPrinter;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.sse.ui.internal.taginfo.AbstractHoverProcessor;

public class JSONHoverProcessor
extends AbstractHoverProcessor
implements ITextHoverExtension2,
IInformationProviderExtension2 {
    private IInformationControlCreator hoverControlCreator;
    private IInformationControlCreator presenterControlCreator;

    public String getHoverInfo(ITextViewer viewer, IRegion hoverRegion) {
        JSONBrowserInformationControlInput info = (JSONBrowserInformationControlInput)((Object)this.getHoverInfo2(viewer, hoverRegion));
        return info != null ? info.getHtml() : null;
    }

    public Object getHoverInfo2(ITextViewer viewer, IRegion hoverRegion) {
        if (hoverRegion == null || viewer == null || viewer.getDocument() == null) {
            return null;
        }
        int documentOffset = hoverRegion.getOffset();
        String html = this.computeHoverHelp(viewer, documentOffset);
        if (html != null) {
            return new JSONBrowserInformationControlInput(null, html, 20);
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        String regionType;
        if (textViewer == null || textViewer.getDocument() == null) {
            return null;
        }
        IStructuredDocumentRegion flatNode = ((IStructuredDocument)textViewer.getDocument()).getRegionAtCharacterOffset(offset);
        ITextRegion region = null;
        if (flatNode != null) {
            region = flatNode.getRegionAtCharacterOffset(offset);
        }
        if (region != null && ((regionType = region.getType()) == "JSON_OBJECT_KEY" || JSONUtil.isJSONSimpleValue((String)regionType))) {
            try {
                IRegion line = textViewer.getDocument().getLineInformationOfOffset(offset);
                if (offset > line.getOffset() && offset < line.getOffset() + line.getLength() && offset < flatNode.getTextEndOffset(region)) {
                    return new Region(flatNode.getStartOffset(region), region.getTextLength());
                }
            }
            catch (BadLocationException e) {
                Logger.logException(e);
            }
        }
        return null;
    }

    protected String computeHoverHelp(ITextViewer textViewer, int documentPosition) {
        ITextRegion region;
        String result = null;
        IndexedRegion treeNode = ContentAssistUtils.getNodeAt((ITextViewer)textViewer, (int)documentPosition);
        if (treeNode == null) {
            return null;
        }
        IJSONNode node = (IJSONNode)treeNode;
        IJSONNode parentNode = node.getParentNode();
        IStructuredDocumentRegion flatNode = ((IStructuredDocument)textViewer.getDocument()).getRegionAtCharacterOffset(documentPosition);
        if (flatNode != null && (region = flatNode.getRegionAtCharacterOffset(documentPosition)) != null) {
            result = this.computeRegionHelp(treeNode, parentNode, flatNode, region);
        }
        return result;
    }

    protected String computeRegionHelp(IndexedRegion treeNode, IJSONNode parentNode, IStructuredDocumentRegion flatNode, ITextRegion region) {
        if (region == null) {
            return null;
        }
        String regionType = region.getType();
        if (treeNode instanceof IJSONPair && regionType == "JSON_OBJECT_KEY") {
            return this.computeObjectKeyHelp((IJSONPair)treeNode, parentNode, flatNode, region);
        }
        if (treeNode instanceof IJSONValue && JSONUtil.isJSONSimpleValue((String)regionType)) {
            return this.computeValueHelp((IJSONValue)treeNode, parentNode, flatNode, region);
        }
        return null;
    }

    protected String computeObjectKeyHelp(IJSONPair treeNode, IJSONNode parentNode, IStructuredDocumentRegion flatNode, ITextRegion region) {
        return HTMLJSONPrinter.getAdditionalProposalInfo(treeNode);
    }

    protected String computeValueHelp(IJSONValue treeNode, IJSONNode parentNode, IStructuredDocumentRegion flatNode, ITextRegion region) {
        return HTMLJSONPrinter.getAdditionalProposalInfo(treeNode);
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.hoverControlCreator == null) {
            this.hoverControlCreator = new JSONHoverControlCreator(this.getInformationPresenterControlCreator());
        }
        return this.hoverControlCreator;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.presenterControlCreator == null) {
            this.presenterControlCreator = new JSONPresenterControlCreator();
        }
        return this.presenterControlCreator;
    }
}

