/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.MigLayout.gef;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wb.core.gef.command.EditCommand;
import org.eclipse.wb.core.gef.policy.layout.generic.AbstractPopupFigure;
import org.eclipse.wb.core.gef.policy.layout.grid.AbstractGridSelectionEditPolicy;
import org.eclipse.wb.core.gef.policy.layout.grid.IGridInfo;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.gef.core.requests.KeyRequest;
import org.eclipse.wb.gef.graphical.handles.Handle;
import org.eclipse.wb.gef.graphical.policies.GraphicalEditPolicy;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.swing.MigLayout.gef.MigGridHelper;
import org.eclipse.wb.internal.swing.MigLayout.model.CellConstraintsSupport;
import org.eclipse.wb.internal.swing.MigLayout.model.MigColumnInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.MigLayoutInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.MigRowInfo;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;

public final class MigSelectionEditPolicy
extends AbstractGridSelectionEditPolicy {
    private final MigLayoutInfo m_layout;
    private final ComponentInfo m_component;
    private final MigGridHelper m_gridHelper = new MigGridHelper((GraphicalEditPolicy)this, false);

    public MigSelectionEditPolicy(MigLayoutInfo layout, ComponentInfo component) {
        super((IAbstractComponentInfo)component);
        this.m_layout = layout;
        this.m_component = component;
    }

    protected boolean isActiveLayout() {
        return this.m_component.getParent().getChildren().contains(this.m_layout);
    }

    protected IGridInfo getGridInfo() {
        return this.m_layout.getGridInfo();
    }

    protected List<Handle> createSelectionHandles() {
        ArrayList<Handle> handlesList = new ArrayList<Handle>();
        handlesList.add((Handle)this.createMoveHandle());
        handlesList.add(this.createSpanHandle(1, 0.25));
        handlesList.add(this.createSpanHandle(8, 0.25));
        handlesList.add(this.createSpanHandle(16, 0.75));
        handlesList.add(this.createSpanHandle(4, 0.75));
        return handlesList;
    }

    protected void showPrimarySelection() {
        super.showPrimarySelection();
        this.m_gridHelper.showGridFeedback();
    }

    protected void hideSelection() {
        this.m_gridHelper.eraseGridFeedback();
        super.hideSelection();
    }

    protected IFigure createAlignmentFigure(IAbstractComponentInfo component, boolean horizontal) {
        IEditPartViewer viewer = this.getHost().getViewer();
        final CellConstraintsSupport constraints = MigLayoutInfo.getConstraints((ComponentInfo)component);
        if (horizontal) {
            return new AbstractPopupFigure(viewer, 9, 5){

                protected ImageDescriptor getImageDescriptor() {
                    return constraints.getSmallAlignmentImageDescriptor(true);
                }

                protected void fillMenu(IMenuManager manager) {
                    constraints.fillHorizontalAlignmentMenu(manager);
                }
            };
        }
        return new AbstractPopupFigure(viewer, 5, 9){

            protected ImageDescriptor getImageDescriptor() {
                return constraints.getSmallAlignmentImageDescriptor(false);
            }

            protected void fillMenu(IMenuManager manager) {
                constraints.fillVerticalAlignmentMenu(manager);
            }
        };
    }

    protected Command createSpanCommand(boolean horizontal, final Rectangle cells) {
        return new EditCommand((ObjectInfo)this.m_layout){

            protected void executeEdit() throws Exception {
                MigSelectionEditPolicy.this.m_layout.command_setCells(MigSelectionEditPolicy.this.m_component, cells);
            }
        };
    }

    public void performRequest(Request request) {
        KeyRequest keyRequest;
        if (request instanceof KeyRequest && (keyRequest = (KeyRequest)request).isPressed()) {
            char c = keyRequest.getCharacter();
            if (c == 'd') {
                this.setAlignment(MigColumnInfo.Alignment.DEFAULT);
            } else if (c == 'l') {
                this.setAlignment(MigColumnInfo.Alignment.LEFT);
            } else if (c == 'c') {
                this.setAlignment(MigColumnInfo.Alignment.CENTER);
            } else if (c == 'r') {
                this.setAlignment(MigColumnInfo.Alignment.RIGHT);
            } else if (c == 'f') {
                this.setAlignment(MigColumnInfo.Alignment.FILL);
            } else if (c == 'q') {
                this.setAlignment(MigColumnInfo.Alignment.LEADING);
            } else if (c == 'w') {
                this.setAlignment(MigColumnInfo.Alignment.TRAILING);
            }
            if (c == 'D') {
                this.setAlignment(MigRowInfo.Alignment.DEFAULT);
            } else if (c == 't') {
                this.setAlignment(MigRowInfo.Alignment.TOP);
            } else if (c == 'm') {
                this.setAlignment(MigRowInfo.Alignment.CENTER);
            } else if (c == 'b') {
                this.setAlignment(MigRowInfo.Alignment.BOTTOM);
            } else if (c == 'F') {
                this.setAlignment(MigRowInfo.Alignment.FILL);
            } else if (c == 'a') {
                this.setAlignment(MigRowInfo.Alignment.BASELINE);
            }
        }
    }

    private void setAlignment(final MigColumnInfo.Alignment alignment) {
        ExecutionUtils.run((ObjectInfo)this.m_layout, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                CellConstraintsSupport constraints = MigLayoutInfo.getConstraints(MigSelectionEditPolicy.this.m_component);
                constraints.setHorizontalAlignment(alignment);
                constraints.write();
            }
        });
    }

    private void setAlignment(final MigRowInfo.Alignment alignment) {
        ExecutionUtils.run((ObjectInfo)this.m_layout, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                CellConstraintsSupport constraints = MigLayoutInfo.getConstraints(MigSelectionEditPolicy.this.m_component);
                constraints.setVerticalAlignment(alignment);
                constraints.write();
            }
        });
    }
}

