/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.serial.ui;

import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionWorkingCopy;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.serial.internal.ui.Activator;
import org.eclipse.remote.serial.ui.SerialPortConnectionBlock;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class SerialPortConnectionPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    protected SerialPortConnectionBlock block = new SerialPortConnectionBlock();
    protected IRemoteConnectionWorkingCopy workingCopy;

    protected Control createContents(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        this.block.addUpdateListener(new SerialPortConnectionBlock.SerialBlockUpdateListener(this.block){

            @Override
            public void update() {
                SerialPortConnectionPropertyPage.this.setValid(SerialPortConnectionPropertyPage.this.block.isComplete());
            }
        });
        IRemoteConnection remoteConnection = (IRemoteConnection)this.getElement().getAdapter(IRemoteConnection.class);
        this.workingCopy = remoteConnection != null ? remoteConnection.getWorkingCopy() : null;
        this.block.createBlock(comp, this.workingCopy);
        return comp;
    }

    public boolean performOk() {
        if (this.workingCopy != null) {
            this.workingCopy.setName(this.block.getConnectionName());
            this.workingCopy.setAttribute("serial.portName", this.block.getPortName());
            this.workingCopy.setAttribute("serial.baudRate", Integer.toString(this.block.getBaudRateIndex()));
            this.workingCopy.setAttribute("serial.byteSize", Integer.toString(this.block.getByteSizeIndex()));
            this.workingCopy.setAttribute("serial.parity", Integer.toString(this.block.getParityIndex()));
            this.workingCopy.setAttribute("serial.stopBits", Integer.toString(this.block.getStopBitsIndex()));
            try {
                this.workingCopy.save();
            }
            catch (RemoteConnectionException e) {
                Activator.log((Exception)((Object)e));
                return false;
            }
        }
        return true;
    }
}

