/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.idioms.scoping;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.xtext.idioms.EPackageDeclaration;
import org.eclipse.ocl.xtext.idioms.IdiomsImport;
import org.eclipse.ocl.xtext.idioms.IdiomsModel;
import org.eclipse.ocl.xtext.idioms.IdiomsPackage;
import org.eclipse.ocl.xtext.idioms.scoping.AbstractIdiomsScopeProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.AbstractScope;

public class IdiomsScopeProvider
extends AbstractIdiomsScopeProvider {
    public IScope getScope(EObject context, EReference reference) {
        assert (context != null);
        if (reference == IdiomsPackage.Literals.EPACKAGE_DECLARATION__EPACKAGE) {
            return new ImportEPackageScope((EPackageDeclaration)context);
        }
        if (reference == IdiomsPackage.Literals.IDIOMS_IMPORT__IDIOMS_MODEL) {
            return new ImportIdiomsModelScope((IdiomsImport)context);
        }
        EClass eReferenceType = reference.getEReferenceType();
        if (eReferenceType == EcorePackage.Literals.EPACKAGE) {
            IdiomsModel idiomsModel = (IdiomsModel)EcoreUtil.getRootContainer((EObject)context);
            assert (idiomsModel != null);
            return new ImportedEPackageScope(idiomsModel);
        }
        if (eReferenceType == IdiomsPackage.Literals.IDIOMS_MODEL) {
            IdiomsModel idiomsModel = (IdiomsModel)EcoreUtil.getRootContainer((EObject)context);
            assert (idiomsModel != null);
            return new ImportedIdiomsModelScope(idiomsModel);
        }
        return super.getScope(context, reference);
    }

    public class ImportEPackageScope
    extends AbstractScope {
        protected final @NonNull EPackageDeclaration ePackageImport;

        public ImportEPackageScope(EPackageDeclaration ePackageImport) {
            super(NULLSCOPE, false);
            this.ePackageImport = ePackageImport;
        }

        protected Iterable<IEObjectDescription> getAllLocalElements() {
            ArrayList<IEObjectDescription> allElements = new ArrayList<IEObjectDescription>();
            allElements.add(EObjectDescription.create((QualifiedName)QualifiedName.create((String)this.ePackageImport.getAs()), (EObject)this.ePackageImport.getEPackage()));
            return allElements;
        }
    }

    public class ImportIdiomsModelScope
    extends AbstractScope {
        protected final @NonNull IdiomsImport idiomsImport;

        public ImportIdiomsModelScope(IdiomsImport idiomsImport) {
            super(NULLSCOPE, false);
            this.idiomsImport = idiomsImport;
        }

        protected Iterable<IEObjectDescription> getAllLocalElements() {
            ArrayList<IEObjectDescription> allElements = new ArrayList<IEObjectDescription>();
            IdiomsModel idiomsModel = this.idiomsImport.getIdiomsModel();
            String as = this.idiomsImport.getAs();
            if (as == null) {
                as = idiomsModel.getName();
            }
            allElements.add(EObjectDescription.create((QualifiedName)QualifiedName.create((String)as), (EObject)idiomsModel));
            return allElements;
        }
    }

    public class ImportedEPackageScope
    extends AbstractScope {
        protected final @NonNull IdiomsModel idiomsModel;

        public ImportedEPackageScope(IdiomsModel idiomsModel) {
            super(NULLSCOPE, false);
            this.idiomsModel = idiomsModel;
        }

        protected Iterable<IEObjectDescription> getAllLocalElements() {
            ArrayList<IEObjectDescription> allElements = new ArrayList<IEObjectDescription>();
            for (EPackageDeclaration ePackageImport : this.idiomsModel.getOwnedImportDeclarations()) {
                EPackage ePackage = ePackageImport.getEPackage();
                String as = ePackageImport.getAs();
                if (as == null) continue;
                allElements.add(EObjectDescription.create((QualifiedName)QualifiedName.create((String)as), (EObject)ePackage));
            }
            return allElements;
        }
    }

    public static class ImportedIdiomsModelScope
    extends AbstractScope {
        protected final @NonNull IdiomsModel idiomsModel;

        public ImportedIdiomsModelScope(@NonNull IdiomsModel idiomsModel) {
            super(NULLSCOPE, false);
            this.idiomsModel = idiomsModel;
        }

        protected Iterable<IEObjectDescription> getAllLocalElements() {
            ArrayList<IEObjectDescription> allElements = new ArrayList<IEObjectDescription>();
            for (IdiomsModel anIdiomsModel : this.idiomsModel.getIdiomsModels()) {
                allElements.add(EObjectDescription.create((QualifiedName)QualifiedName.create((String)anIdiomsModel.getName()), (EObject)anIdiomsModel));
            }
            return allElements;
        }

        public IEObjectDescription getSingleElement(QualifiedName name) {
            String simpleName = name.toString();
            IdiomsModel referencedIdiomsModel = this.idiomsModel.getIdiomsModel(simpleName);
            return referencedIdiomsModel != null ? EObjectDescription.create((QualifiedName)name, (EObject)referencedIdiomsModel) : null;
        }
    }
}

