/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library.executor;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.evaluation.ModelManager;
import org.eclipse.ocl.pivot.ids.ClassId;
import org.eclipse.ocl.pivot.ids.IdManager;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.library.executor.LazyModelManager;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.Nameable;

public class LazyEcoreModelManager
extends LazyModelManager
implements ModelManager.EcoreModelManager {
    private static final @NonNull List<@NonNull Object> NO_OBJECTS = Collections.emptyList();
    private final @NonNull List<@NonNull EObject> extentRoots;
    private final @NonNull List<@NonNull EClass> allInstancesEClasses;
    private final @NonNull List<@NonNull EReference> implicitOppositeEReferences;
    private @Nullable Map<@NonNull EClass, @NonNull EClassAnalysis> eClass2eClassAnalysis = null;
    private @Nullable Map<@NonNull EReference, @NonNull EReferenceAnalysis> eReference2eReferenceAnalysis = null;
    private @Nullable Map<@NonNull ClassId, @NonNull EClass> classId2eClass = null;

    public static @NonNull List<@NonNull EObject> computeRoots(@NonNull EObject contextEObject) {
        ArrayList<@NonNull EObject> allRootContents = new ArrayList<EObject>();
        Resource contextResource = contextEObject.eResource();
        if (contextResource != null) {
            ResourceSet resourceSet = contextResource.getResourceSet();
            if (resourceSet != null) {
                for (Resource resource : resourceSet.getResources()) {
                    allRootContents.addAll((Collection<EObject>)resource.getContents());
                }
            } else {
                allRootContents.addAll((Collection<EObject>)contextResource.getContents());
            }
        } else {
            EObject rootContainer = EcoreUtil.getRootContainer((EObject)contextEObject);
            assert (rootContainer != null);
            allRootContents.add(rootContainer);
        }
        return allRootContents;
    }

    public LazyEcoreModelManager(@NonNull EObject contextObject) {
        this(LazyEcoreModelManager.computeRoots(contextObject), null, null);
    }

    public LazyEcoreModelManager(@NonNull List<@NonNull EObject> extentRoots, @Nullable Iterable<@NonNull EClass> allInstancesClasses, @Nullable Iterable<@NonNull EReference> implicitOpposites) {
        this.extentRoots = extentRoots;
        for (EObject eObject : extentRoots) {
            assert (eObject.eContainer() == null);
        }
        this.allInstancesEClasses = allInstancesClasses != null ? Lists.newArrayList(allInstancesClasses) : new ArrayList();
        ArrayList arrayList = this.implicitOppositeEReferences = implicitOpposites != null ? Lists.newArrayList(implicitOpposites) : new ArrayList();
        assert (new HashSet<EClass>(this.allInstancesEClasses).size() == this.allInstancesEClasses.size());
        assert (new HashSet<EReference>(this.implicitOppositeEReferences).size() == this.implicitOppositeEReferences.size());
    }

    @Override
    public void addAllInstancesEClass(@NonNull EClass allInstancesEClass) {
        if (!this.allInstancesEClasses.contains(allInstancesEClass)) {
            this.allInstancesEClasses.add(allInstancesEClass);
            this.eClass2eClassAnalysis = null;
            this.eReference2eReferenceAnalysis = null;
        }
    }

    @Override
    public void addImplicitOppositeEReference(@NonNull EReference implicitOppositeEReference) {
        if (!this.implicitOppositeEReferences.contains(implicitOppositeEReference)) {
            this.implicitOppositeEReferences.add(implicitOppositeEReference);
            this.eClass2eClassAnalysis = null;
            this.eReference2eReferenceAnalysis = null;
        }
    }

    @Override
    public synchronized void analyze() {
        Map<@NonNull EClass, @NonNull EClassAnalysis> eClass2eClassAnalysis2 = this.eClass2eClassAnalysis;
        if (eClass2eClassAnalysis2 == null) {
            eClass2eClassAnalysis2 = this.eClass2eClassAnalysis = new HashMap<EClass, EClassAnalysis>();
            for (EClass allInstancesEClass : this.allInstancesEClasses) {
                eClass2eClassAnalysis2.put(allInstancesEClass, new EClassAnalysisWithInstances(this, allInstancesEClass));
            }
            for (EClassAnalysis eClassAnalysis : eClass2eClassAnalysis2.values()) {
                ((EClassAnalysisWithInstances)eClassAnalysis).analyzeInheritance();
            }
        }
        if (this.allInstancesEClasses.size() + this.implicitOppositeEReferences.size() > 0 || this.classId2eClass != null) {
            TreeIterator tit = EcoreUtil.getAllContents(this.extentRoots);
            while (tit.hasNext()) {
                EObject eObject = (EObject)tit.next();
                assert (eObject != null);
                EClass eClass = eObject.eClass();
                assert (eClass != null);
                EClassAnalysis eClassAnalysis = this.getEClassAnalysis(eClass);
                eClassAnalysis.analyzeEObject(eObject);
            }
        }
        if (this.eReference2eReferenceAnalysis == null) {
            this.eReference2eReferenceAnalysis = new HashMap<EReference, EReferenceAnalysis>();
        }
        for (EClass eClass : this.allInstancesEClasses) {
            assert (this.eClass2eClassAnalysis != null && this.eClass2eClassAnalysis.containsKey(eClass)) : "No eClass2eClassAnalysis for " + eClass;
        }
    }

    protected @Nullable EClassAnalysis basicGetEClassAnalysis(@NonNull EClass eClass) {
        return this.eClass2eClassAnalysis != null ? this.eClass2eClassAnalysis.get(eClass) : null;
    }

    protected @NonNull EClassAnalysis getEClassAnalysis(@NonNull EClass eClass) {
        Map<@NonNull EClass, @NonNull EClassAnalysis> eClass2eClassAnalysis2 = this.eClass2eClassAnalysis;
        assert (eClass2eClassAnalysis2 != null);
        EClassAnalysis eClassAnalysis = eClass2eClassAnalysis2.get(eClass);
        if (eClassAnalysis == null) {
            EClassAnalysisWithInstances theEClassAnalysisWithInstances = null;
            for (EClass eSuperClass : eClass.getESuperTypes()) {
                assert (eSuperClass != null);
                EClassAnalysis eSuperClassAnalysis = this.getEClassAnalysis(eSuperClass);
                EClassAnalysisWithInstances eClassAnalysisWithInstances = eSuperClassAnalysis.basicGetEClassAnalysisWithInstances();
                if (eClassAnalysisWithInstances == null) continue;
                if (theEClassAnalysisWithInstances == null) {
                    theEClassAnalysisWithInstances = eClassAnalysisWithInstances;
                    continue;
                }
                assert (theEClassAnalysisWithInstances != eClassAnalysisWithInstances);
                eClassAnalysis = new EClassAnalysisWithInstances(this, eClass);
                break;
            }
            if (eClassAnalysis == null) {
                eClassAnalysis = new EClassAnalysisWithoutInstances(this, eClass, theEClassAnalysisWithInstances);
            }
            eClass2eClassAnalysis2.put(eClass, eClassAnalysis);
        }
        return eClassAnalysis;
    }

    protected @Nullable EReferenceAnalysis getEReferenceAnalysis(@NonNull EReference eReference) {
        Map<@NonNull EReference, @NonNull EReferenceAnalysis> eReference2eReferenceAnalysis2 = this.eReference2eReferenceAnalysis;
        if (eReference2eReferenceAnalysis2 == null) {
            eReference2eReferenceAnalysis2 = this.eReference2eReferenceAnalysis = new HashMap<EReference, EReferenceAnalysis>();
            for (EReference implicitOppositeEReference : this.implicitOppositeEReferences) {
                eReference2eReferenceAnalysis2.put(implicitOppositeEReference, new EReferenceAnalysis(implicitOppositeEReference));
            }
        }
        return eReference2eReferenceAnalysis2.get(eReference);
    }

    @Override
    public @Nullable Iterable<@NonNull ? extends Object> getInstances(@NonNull Class type) {
        EObject esObject = type.getESObject();
        if (esObject instanceof EClass) {
            return this.getInstances((EClass)esObject);
        }
        return this.getInstances(type.getTypeId());
    }

    @Override
    public @Nullable Iterable<@NonNull EObject> getInstances(@NonNull EClass eClass) {
        EClassAnalysis eClassAnalysis;
        this.addAllInstancesEClass(eClass);
        Map<@NonNull EClass, @NonNull EClassAnalysis> eClass2eClassAnalysis2 = this.eClass2eClassAnalysis;
        if (eClass2eClassAnalysis2 == null || (eClassAnalysis = eClass2eClassAnalysis2.get(eClass)) == null) {
            this.analyze();
            eClass2eClassAnalysis2 = this.eClass2eClassAnalysis;
            assert (eClass2eClassAnalysis2 != null);
            eClassAnalysis = eClass2eClassAnalysis2.get(eClass);
            assert (this.allInstancesEClasses.contains(eClass)) : "No allInstancesEClasses for " + eClass;
            assert (eClassAnalysis != null) : "No EClassAnalysis for " + eClass;
        }
        return eClassAnalysis.getInstances();
    }

    @Override
    public @Nullable Iterable<@NonNull EObject> getInstances(@NonNull TypeId typeId) {
        EClass eClass;
        Map<@NonNull ClassId, @NonNull EClass> classId2eClass2 = this.classId2eClass;
        if (classId2eClass2 == null) {
            classId2eClass2 = this.classId2eClass = new HashMap<ClassId, EClass>();
            Map<@NonNull EClass, @NonNull EClassAnalysis> eClass2eClassAnalysis2 = this.eClass2eClassAnalysis;
            if (eClass2eClassAnalysis2 == null) {
                this.analyze();
                eClass2eClassAnalysis2 = this.eClass2eClassAnalysis;
                assert (eClass2eClassAnalysis2 != null);
            }
            for (Map.Entry<EClass, EClassAnalysis> entry : eClass2eClassAnalysis2.entrySet()) {
                EClass eClass2 = entry.getKey();
                ClassId classId = IdManager.getClassId(eClass2);
                EClass old = classId2eClass2.put(classId, eClass2);
                assert (old == null);
            }
        }
        if ((eClass = classId2eClass2.get(typeId)) == null) {
            return null;
        }
        return this.getInstances(eClass);
    }

    @Override
    public @Nullable Iterable<@NonNull EObject> getOpposites(@NonNull EReference eReference, @NonNull EObject eTarget) {
        EReferenceAnalysis eReferenceAnalysis;
        Map<@NonNull EReference, @NonNull EReferenceAnalysis> eReference2eReferenceAnalysis2 = this.eReference2eReferenceAnalysis;
        if (eReference2eReferenceAnalysis2 == null) {
            this.addImplicitOppositeEReference(eReference);
            this.analyze();
            eReference2eReferenceAnalysis2 = this.eReference2eReferenceAnalysis;
            assert (eReference2eReferenceAnalysis2 != null);
        }
        if ((eReferenceAnalysis = eReference2eReferenceAnalysis2.get(eReference)) == null) {
            this.addImplicitOppositeEReference(eReference);
            this.analyze();
            eReference2eReferenceAnalysis2 = this.eReference2eReferenceAnalysis;
            assert (eReference2eReferenceAnalysis2 != null);
            eReferenceAnalysis = eReference2eReferenceAnalysis2.get(eReference);
            assert (eReferenceAnalysis != null);
        }
        return eReferenceAnalysis.basicGetOpposites(eTarget);
    }

    @Override
    public @NonNull Iterable<@NonNull Object> getOpposite(@NonNull Property target2sourceProperty, @NonNull Object sourceObject) {
        EReference eReference = (EReference)target2sourceProperty.getESObject();
        assert (eReference != null);
        Iterable<@NonNull EObject> objects = this.getOpposites(eReference, (EObject)sourceObject);
        if (objects != null) {
            Iterable<@NonNull EObject> castObjects = objects;
            return castObjects;
        }
        return NO_OBJECTS;
    }

    @Override
    @Deprecated
    protected boolean isInstance(@NonNull Type type, @NonNull EObject element) {
        throw new UnsupportedOperationException("Not used for Ecore conformance");
    }

    @Override
    public void resetAnalysis() {
        this.classId2eClass = null;
        this.eClass2eClassAnalysis = null;
        this.eReference2eReferenceAnalysis = null;
    }

    @Override
    public String toString() {
        Map<EReference, EReferenceAnalysis> eReference2eReferenceAnalysis2;
        StringBuilder s = new StringBuilder();
        boolean isFirst = true;
        Map<@NonNull EClass, @NonNull EClassAnalysis> eClass2eClassAnalysis2 = this.eClass2eClassAnalysis;
        if (eClass2eClassAnalysis2 != null) {
            ArrayList<@NonNull EClassAnalysis> eClassAnalyses = new ArrayList<EClassAnalysis>(eClass2eClassAnalysis2.values());
            Collections.sort(eClassAnalyses, NameUtil.NAMEABLE_COMPARATOR);
            for (EClassAnalysis eClassAnalysis : eClassAnalyses) {
                if (eClassAnalysis instanceof EClassAnalysisWithoutInstances && ((EClassAnalysisWithoutInstances)eClassAnalysis).eClassAnalysisWithInstances == null) continue;
                if (!isFirst) {
                    s.append("\n");
                }
                s.append(eClassAnalysis.toString());
                isFirst = false;
            }
        }
        if ((eReference2eReferenceAnalysis2 = this.eReference2eReferenceAnalysis) != null) {
            ArrayList<@NonNull EReferenceAnalysis> eReferenceAnalyses = new ArrayList<EReferenceAnalysis>(eReference2eReferenceAnalysis2.values());
            Collections.sort(eReferenceAnalyses, NameUtil.NAMEABLE_COMPARATOR);
            for (EReferenceAnalysis eReferenceAnalysis : eReferenceAnalyses) {
                if (!isFirst) {
                    s.append("\n");
                }
                s.append(eReferenceAnalysis.toString());
                isFirst = false;
            }
        }
        return s.toString();
    }

    private static abstract class EClassAnalysis
    implements Nameable {
        protected final @NonNull LazyEcoreModelManager modelManager;
        protected final @NonNull EClass eClass;
        protected @NonNull EReferenceAnalysis @Nullable [] eOppositeAnalyses;

        protected EClassAnalysis(@NonNull LazyEcoreModelManager modelManager, @NonNull EClass eClass) {
            this.modelManager = modelManager;
            this.eClass = eClass;
            this.eOppositeAnalyses = this.analyzeEClass();
        }

        private @NonNull EReferenceAnalysis @Nullable [] analyzeEClass() {
            ArrayList<@NonNull EReferenceAnalysis> eOppositeAnalyses = null;
            for (EStructuralFeature eStructuralFeature : this.eClass.getEAllStructuralFeatures()) {
                EReferenceAnalysis eOppositeAnalysis;
                EReference eReference;
                if (!(eStructuralFeature instanceof EReference) || (eReference = (EReference)eStructuralFeature).getEOpposite() != null || (eOppositeAnalysis = this.modelManager.getEReferenceAnalysis(eReference)) == null) continue;
                assert (!eReference.isTransient() && !eReference.isVolatile());
                if (eOppositeAnalyses == null) {
                    eOppositeAnalyses = new ArrayList<EReferenceAnalysis>();
                }
                assert (!eOppositeAnalyses.contains(eOppositeAnalysis));
                eOppositeAnalyses.add(eOppositeAnalysis);
            }
            return eOppositeAnalyses != null ? eOppositeAnalyses.toArray(new EReferenceAnalysis[eOppositeAnalyses.size()]) : null;
        }

        public abstract void analyzeEObject(@NonNull EObject var1);

        public void analyzeEOpposites(@NonNull EObject eObject) {
            assert (eObject.eClass() == this.eClass);
            @NonNull EReferenceAnalysis[] eOppositeAnalyses2 = this.eOppositeAnalyses;
            if (eOppositeAnalyses2 != null) {
                EReferenceAnalysis[] eReferenceAnalysisArray = eOppositeAnalyses2;
                int n = eOppositeAnalyses2.length;
                int n2 = 0;
                while (n2 < n) {
                    @NonNull EReferenceAnalysis eOppositeAnalysis = eReferenceAnalysisArray[n2];
                    eOppositeAnalysis.analyzeEObject(eObject);
                    ++n2;
                }
            }
        }

        public abstract @Nullable EClassAnalysisWithInstances basicGetEClassAnalysisWithInstances();

        public abstract @NonNull Iterable<@NonNull EObject> getInstances();

        @Override
        public @NonNull String getName() {
            return String.valueOf(this.eClass.getEPackage().getName()) + "::" + this.eClass.getName();
        }
    }

    private static class EClassAnalysisWithInstances
    extends EClassAnalysis {
        protected final @NonNull List<@NonNull EObject> localInstances = new ArrayList<EObject>();
        private @Nullable List<@NonNull List<@NonNull EObject>> indirectInstances = null;

        public EClassAnalysisWithInstances(@NonNull LazyEcoreModelManager modelManager, @NonNull EClass eClass) {
            super(modelManager, eClass);
        }

        protected void addLocalInstance(@NonNull EObject eObject) {
            assert (!this.localInstances.contains(eObject));
            this.localInstances.add(eObject);
        }

        @Override
        public void analyzeEObject(@NonNull EObject eObject) {
            this.addLocalInstance(eObject);
            this.analyzeEOpposites(eObject);
        }

        public void analyzeInheritance() {
            for (EClass eSuperClass : this.eClass.getEAllSuperTypes()) {
                List<EObject> localInstances2;
                assert (eSuperClass != null);
                EClassAnalysis eClassAnalysis = this.modelManager.basicGetEClassAnalysis(eSuperClass);
                if (!(eClassAnalysis instanceof EClassAnalysisWithInstances)) continue;
                List<@NonNull List<@NonNull EObject>> indirectInstances2 = this.indirectInstances;
                if (indirectInstances2 == null) {
                    indirectInstances2 = this.indirectInstances = new ArrayList<List<EObject>>();
                    indirectInstances2.add(this.localInstances);
                }
                if (indirectInstances2.contains(localInstances2 = ((EClassAnalysisWithInstances)eClassAnalysis).localInstances)) continue;
                indirectInstances2.add(localInstances2);
            }
        }

        @Override
        public @NonNull EClassAnalysisWithInstances basicGetEClassAnalysisWithInstances() {
            return this;
        }

        @Override
        public @NonNull Iterable<@NonNull EObject> getInstances() {
            if (this.indirectInstances == null) {
                return this.localInstances;
            }
            return Iterables.concat(this.indirectInstances);
        }

        public @NonNull String toString() {
            return String.valueOf(this.getName()) + "[" + this.localInstances.size() + "]";
        }
    }

    private static class EClassAnalysisWithoutInstances
    extends EClassAnalysis {
        protected final @Nullable EClassAnalysisWithInstances eClassAnalysisWithInstances;

        public EClassAnalysisWithoutInstances(@NonNull LazyEcoreModelManager modelManager, @NonNull EClass eClass, @Nullable EClassAnalysisWithInstances eClassAnalysisWithInstances) {
            super(modelManager, eClass);
            this.eClassAnalysisWithInstances = eClassAnalysisWithInstances;
        }

        @Override
        public void analyzeEObject(@NonNull EObject eObject) {
            if (this.eClassAnalysisWithInstances != null) {
                this.eClassAnalysisWithInstances.addLocalInstance(eObject);
            }
            this.analyzeEOpposites(eObject);
        }

        @Override
        public @Nullable EClassAnalysisWithInstances basicGetEClassAnalysisWithInstances() {
            return this.eClassAnalysisWithInstances;
        }

        @Override
        public @NonNull Iterable<@NonNull EObject> getInstances() {
            throw new IllegalStateException("No allInstances() support for a " + this.eClass.getName());
        }

        public @NonNull String toString() {
            return String.valueOf(this.getName()) + " -> " + this.eClassAnalysisWithInstances;
        }
    }

    private static class EReferenceAnalysis
    implements Nameable {
        protected final @NonNull EReference eReference;
        protected final @NonNull Map<@NonNull EObject, @NonNull Object> eTarget2eSourceOrSources = new HashMap<EObject, Object>();

        public EReferenceAnalysis(@NonNull EReference eReference) {
            this.eReference = eReference;
            assert (eReference.getEOpposite() == null);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private void addOpposite(@NonNull EObject eObject, @NonNull EObject oppositeEObject) {
            Object sourceOrSources = this.eTarget2eSourceOrSources.get(oppositeEObject);
            if (sourceOrSources == null) {
                this.eTarget2eSourceOrSources.put(oppositeEObject, eObject);
            } else if (sourceOrSources instanceof EObject) {
                if (!this.eReference.isUnique() || sourceOrSources != eObject) {
                    ArrayList<@NonNull EObject> objects = new ArrayList<EObject>();
                    this.eTarget2eSourceOrSources.put(oppositeEObject, objects);
                    objects.add((EObject)sourceOrSources);
                    objects.add(eObject);
                }
            } else {
                @NonNull List objects = (List)sourceOrSources;
                if (!this.eReference.isUnique() || !objects.contains(eObject)) {
                    objects.add(eObject);
                }
            }
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public void analyzeEObject(@NonNull EObject eObject) {
            Object objectOrObjects = eObject.eGet((EStructuralFeature)this.eReference);
            if (this.eReference.isMany()) {
                @NonNull Iterable oppositeEObjects = (Iterable)objectOrObjects;
                for (EObject oppositeEObject : oppositeEObjects) {
                    this.addOpposite(eObject, oppositeEObject);
                }
            } else if (objectOrObjects != null) {
                this.addOpposite(eObject, (EObject)objectOrObjects);
            }
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public @Nullable List<@NonNull EObject> basicGetOpposites(@NonNull EObject oppositeEObject) {
            Object objectOrObjects = this.eTarget2eSourceOrSources.get(oppositeEObject);
            if (objectOrObjects == null) {
                return null;
            }
            if (objectOrObjects instanceof EObject) {
                return Collections.singletonList((EObject)objectOrObjects);
            }
            @NonNull List objects = (List)objectOrObjects;
            return objects;
        }

        @Override
        public @NonNull String getName() {
            EClass eContainingClass = this.eReference.getEContainingClass();
            EPackage ePackage = eContainingClass.getEPackage();
            return String.valueOf(ePackage.getName()) + "::" + eContainingClass.getName() + "::" + this.eReference.getName();
        }

        public @NonNull String toString() {
            return String.valueOf(this.getName()) + "[" + this.eTarget2eSourceOrSources.size() + "]";
        }
    }
}

