/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.ui.internal.celleditors.composite;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.modisco.facet.widgets.celleditors.AbstractCellEditorComposite;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.discovery.ui.Activator;
import org.eclipse.modisco.infra.discovery.ui.Messages;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TargetURIComposite
extends AbstractCellEditorComposite<URI> {
    private static final String DIALOG_TITLE = Messages.TargetURIComposite_selectPlatformURI;
    private final Button button;
    private Text text = null;
    private final Composite fParentControl;

    public TargetURIComposite(final Composite parent, int style) {
        super(parent);
        this.fParentControl = parent;
        GridLayout gd = new GridLayout(2, false);
        gd.marginHeight = 0;
        gd.marginWidth = 0;
        gd.horizontalSpacing = 0;
        this.setLayout((Layout)gd);
        this.text = new Text((Composite)this, style);
        this.text.setLayoutData((Object)new GridData(4, 4, true, false));
        this.button = new Button((Composite)this, 8);
        this.button.setText("...");
        GridData data = new GridData(4, 4, false, true);
        this.button.setLayoutData((Object)data);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                URI originalUri = TargetURIComposite.this.getValue();
                Path originalPath = null;
                if (originalUri != null) {
                    try {
                        if (originalUri.isPlatformResource()) {
                            originalPath = new Path(originalUri.toPlatformString(true));
                        }
                    }
                    catch (IllegalArgumentException iae) {
                        MoDiscoLogger.logInfo((Throwable)iae, (Plugin)Activator.getDefault());
                    }
                }
                URI targetUri = null;
                IFile newFile = WorkspaceResourceDialog.openNewFile((Shell)parent.getShell(), (String)DIALOG_TITLE, (String)DIALOG_TITLE, originalPath, null);
                if (newFile != null) {
                    targetUri = URI.createPlatformResourceURI((String)newFile.getFullPath().toString(), (boolean)true);
                    TargetURIComposite.this.setValue(targetUri);
                }
            }
        });
        final Listener clickListener = new Listener(){

            public void handleEvent(Event event) {
                Control control;
                if (event.widget instanceof Control && (control = (Control)event.widget).getShell() == TargetURIComposite.this.getParentControl().getShell() && event.widget != TargetURIComposite.this.getButton() && event.widget != TargetURIComposite.this.getText() && TargetURIComposite.this.getText().getEditable()) {
                    TargetURIComposite.this.fireCommit();
                }
            }
        };
        Display.getDefault().addFilter(3, clickListener);
        this.text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Display.getDefault().removeFilter(3, clickListener);
            }
        });
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 13 && event.stateMask == 0 || event.keyCode == 0x1000050 && event.stateMask == 0) {
                    if (TargetURIComposite.this.getText().getEditable()) {
                        TargetURIComposite.this.fireCommit();
                    }
                } else if (event.keyCode == 27 && event.stateMask == 0) {
                    TargetURIComposite.this.close();
                }
            }
        });
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TargetURIComposite.this.fireChanged();
            }
        });
        this.text.forceFocus();
    }

    public void setValue(URI value) {
        if (value != null) {
            this.text.setText(value.toString());
        }
    }

    public URI getValue() {
        return URI.createURI((String)this.text.getText());
    }

    protected Composite getParentControl() {
        return this.fParentControl;
    }

    protected Text getText() {
        return this.text;
    }

    protected Button getButton() {
        return this.button;
    }
}

