/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.ui.viewers;

import java.util.Map;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jst.ws.internal.cxf.core.model.WSDL2JavaDataModel;
import org.eclipse.jst.ws.jaxws.core.utils.WSDLUtils;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class PackageNameEditingSupport
extends EditingSupport
implements SelectionListener {
    private CellEditor packageNameCellEditor;
    private Table table;
    private Map<String, String> includedNamespaces;

    public PackageNameEditingSupport(TableViewer tableViewer, CellEditor packageNameCellEditor, WSDL2JavaDataModel model) {
        super((ColumnViewer)tableViewer);
        this.table = tableViewer.getTable();
        this.packageNameCellEditor = packageNameCellEditor;
        this.includedNamespaces = model.getIncludedNamespaces();
        this.table.addSelectionListener((SelectionListener)this);
    }

    protected boolean canEdit(Object element) {
        return this.table.getSelection()[0].getChecked();
    }

    protected CellEditor getCellEditor(Object element) {
        return this.packageNameCellEditor;
    }

    protected Object getValue(Object element) {
        if (this.includedNamespaces.containsKey(element.toString())) {
            return this.includedNamespaces.get(element.toString());
        }
        return WSDLUtils.getPackageNameFromNamespace((String)element.toString());
    }

    protected void setValue(Object namespace, Object packageName) {
        if (namespace != null && packageName != null) {
            this.includedNamespaces.put(namespace.toString(), packageName.toString());
            this.getViewer().update(namespace, null);
        }
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.detail == 32) {
            TableItem item = (TableItem)event.item;
            String namespaceKey = item.getText(0);
            String packageName = item.getText(1);
            if (item.getChecked()) {
                if (!this.includedNamespaces.containsKey(namespaceKey)) {
                    this.includedNamespaces.put(namespaceKey, packageName);
                }
            } else if (this.includedNamespaces.containsKey(namespaceKey)) {
                this.includedNamespaces.remove(namespaceKey);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }
}

