/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards.gen;

import java.util.ArrayList;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jpt.common.ui.JptCommonUiImages;
import org.eclipse.jpt.common.ui.internal.WorkbenchTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.jpt.jpa.gen.internal.ORMGenCustomizer;
import org.eclipse.jpt.jpa.ui.internal.JpaHelpContextIds;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.NewAssociationWizard;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.NewAssociationWizardPage;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.SWTUtil;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.SelectTableDialog;
import org.eclipse.jpt.jpa.ui.wizards.gen.JptJpaUiWizardsEntityGenMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AssociationTablesPage
extends NewAssociationWizardPage {
    private Button simpleAssoBtn;
    private Button mtmAssoBtn;
    private Text table1TextField;
    private Text table2TextField;
    private Text joinTableTextField;
    private Button joinTableBrowse;
    protected final ResourceManager resourceManager;

    public AssociationTablesPage(ORMGenCustomizer customizer, ResourceManager resourceManager) {
        super(customizer, "AssociationTablesPage");
        this.resourceManager = resourceManager;
        this.setTitle(JptJpaUiWizardsEntityGenMessages.GENERATE_ENTITIES_WIZARD_NEW_ASSOC_TABLES_PAGE_TITLE);
        this.setDescription(JptJpaUiWizardsEntityGenMessages.GENERATE_ENTITIES_WIZARD_NEW_ASSOC_TABLES_PAGE_DESC);
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite parent = new Composite(composite, 0);
        parent.setLayout((Layout)new GridLayout(1, true));
        Group assocKindGroup = new Group(parent, 0);
        int nColumns = 3;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        assocKindGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        assocKindGroup.setLayout((Layout)layout);
        WorkbenchTools.setHelp((Control)composite, (String)JpaHelpContextIds.GENERATE_ENTITIES_WIZARD_ASSOCIATION_TABLES);
        assocKindGroup.setText(JptJpaUiWizardsEntityGenMessages.GENERATE_ENTITIES_WIZARD_NEW_ASSOC_TABLES_PAGE_ASSOC_KIND);
        this.simpleAssoBtn = SWTUtil.createButton((Composite)assocKindGroup, 3, JptJpaUiWizardsEntityGenMessages.GENERATE_ENTITIES_WIZARD_NEW_ASSOC_TABLES_PAGE_SIMPLE_ASSOC, 16);
        this.mtmAssoBtn = SWTUtil.createButton((Composite)assocKindGroup, 3, JptJpaUiWizardsEntityGenMessages.GENERATE_ENTITIES_WIZARD_NEW_ASSOC_TABLES_PAGE_M2M_ASSOC, 16);
        Group assocTablesGroup = new Group(parent, 0);
        nColumns = 3;
        layout = new GridLayout();
        layout.numColumns = nColumns;
        assocTablesGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        assocTablesGroup.setLayout((Layout)layout);
        assocTablesGroup.setText(JptJpaUiWizardsEntityGenMessages.GENERATE_ENTITIES_WIZARD_NEW_ASSOC_TABLES_PAGE_ASSOC_TABLES);
        SWTUtil.createLabel((Composite)assocTablesGroup, 1, JptJpaUiWizardsEntityGenMessages.GENERATE_ENTITIES_WIZARD_NEW_ASSOC_TABLES_PAGE_TABLE1);
        this.table1TextField = SWTUtil.createText((Composite)assocTablesGroup, 1);
        this.table1TextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AssociationTablesPage.this.updatePageComplete();
            }
        });
        Button browser1 = SWTUtil.createButton((Composite)assocTablesGroup, 1, "", 0);
        browser1.setImage(this.resourceManager.createImage(JptCommonUiImages.BROWSE_BUTTON));
        browser1.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SelectTableDialog dlg = new SelectTableDialog(SWTUtil.getShell(), AssociationTablesPage.this.resourceManager, AssociationTablesPage.this.customizer.getTableNames());
                if (dlg.open() == 0) {
                    AssociationTablesPage.this.table1TextField.setText(dlg.getSelectedTable());
                    AssociationTablesPage.this.getWizardDataModel().put(NewAssociationWizard.ASSOCIATION_REFERRER_TABLE, AssociationTablesPage.this.table1TextField.getText());
                    AssociationTablesPage.this.getWizard().getContainer().updateButtons();
                    ((NewAssociationWizard)AssociationTablesPage.this.getWizard()).updateTableNames();
                }
                AssociationTablesPage.this.updatePageComplete();
            }
        });
        SWTUtil.createLabel((Composite)assocTablesGroup, 1, JptJpaUiWizardsEntityGenMessages.GENERATE_ENTITIES_WIZARD_NEW_ASSOC_TABLES_PAGE_TABLE2);
        this.table2TextField = SWTUtil.createText((Composite)assocTablesGroup, 1);
        this.table2TextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AssociationTablesPage.this.updatePageComplete();
            }
        });
        Button browser2 = SWTUtil.createButton((Composite)assocTablesGroup, 1, "", 0);
        browser2.setImage(this.resourceManager.createImage(JptCommonUiImages.BROWSE_BUTTON));
        browser2.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SelectTableDialog dlg = new SelectTableDialog(SWTUtil.getShell(), AssociationTablesPage.this.resourceManager, AssociationTablesPage.this.customizer.getTableNames());
                if (dlg.open() == 0) {
                    AssociationTablesPage.this.table2TextField.setText(dlg.getSelectedTable());
                    AssociationTablesPage.this.getWizardDataModel().put(NewAssociationWizard.ASSOCIATION_REFERENCED_TABLE, AssociationTablesPage.this.table2TextField.getText());
                    ((NewAssociationWizard)AssociationTablesPage.this.getWizard()).updateTableNames();
                }
                AssociationTablesPage.this.updatePageComplete();
            }
        });
        SWTUtil.createLabel((Composite)assocTablesGroup, 1, JptJpaUiWizardsEntityGenMessages.GENERATE_ENTITIES_WIZARD_NEW_ASSOC_TABLES_PAGE_INTERMEDIATE_TABLE);
        this.joinTableTextField = SWTUtil.createText((Composite)assocTablesGroup, 1);
        this.joinTableTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AssociationTablesPage.this.updatePageComplete();
            }
        });
        this.joinTableTextField.setEnabled(false);
        this.joinTableBrowse = SWTUtil.createButton((Composite)assocTablesGroup, 1, "", 0);
        this.joinTableBrowse.setImage(this.resourceManager.createImage(JptCommonUiImages.BROWSE_BUTTON));
        this.joinTableBrowse.setEnabled(false);
        this.joinTableBrowse.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SelectTableDialog dlg = new SelectTableDialog(SWTUtil.getShell(), AssociationTablesPage.this.resourceManager, AssociationTablesPage.this.customizer.getSchema());
                if (dlg.open() == 0) {
                    AssociationTablesPage.this.joinTableTextField.setText(dlg.getSelectedTable());
                    AssociationTablesPage.this.getWizardDataModel().put(NewAssociationWizard.ASSOCIATION_JOIN_TABLE, AssociationTablesPage.this.joinTableTextField.getText());
                    ((NewAssociationWizard)AssociationTablesPage.this.getWizard()).updateTableNames();
                    AssociationTablesPage.this.getWizard().getContainer().updateButtons();
                }
                AssociationTablesPage.this.updatePageComplete();
            }
        });
        this.setControl((Control)parent);
        this.simpleAssoBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AssociationTablesPage.this.joinTableTextField.setEnabled(false);
                AssociationTablesPage.this.joinTableTextField.clearSelection();
                AssociationTablesPage.this.joinTableTextField.setText("");
                AssociationTablesPage.this.joinTableBrowse.setEnabled(false);
                AssociationTablesPage.this.getWizardDataModel().put(NewAssociationWizard.ASSOCIATION_CADINALITY, "many-to-one");
                AssociationTablesPage.this.getWizardDataModel().remove(NewAssociationWizard.ASSOCIATION_JOIN_TABLE);
                ((NewAssociationWizard)AssociationTablesPage.this.getWizard()).updateTableNames();
                AssociationTablesPage.this.updatePageComplete();
            }
        });
        this.mtmAssoBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AssociationTablesPage.this.joinTableTextField.setEnabled(true);
                AssociationTablesPage.this.joinTableBrowse.setEnabled(true);
                AssociationTablesPage.this.getWizardDataModel().put(NewAssociationWizard.ASSOCIATION_CADINALITY, "many-to-many");
                ((NewAssociationWizard)AssociationTablesPage.this.getWizard()).updateTableNames();
                AssociationTablesPage.this.updatePageComplete();
            }
        });
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public void updatePageComplete() {
        if (this.table1TextField.getText().length() <= 0 || this.table2TextField.getText().length() <= 0) {
            this.setErrorMessage(null);
            this.setPageComplete(false);
            return;
        }
        String errorMessage = this.buildTableErrorMessage();
        if (errorMessage == null && this.mtmAssoBtn.getSelection()) {
            if (this.joinTableTextField.getText().length() <= 0) {
                this.setErrorMessage(null);
                this.setPageComplete(false);
                return;
            }
            errorMessage = this.buildJoinTableErrorMessage();
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }

    private String buildTableErrorMessage() {
        if (!IterableTools.contains((Iterable)this.customizer.getTableNames(), (Object)this.table1TextField.getText())) {
            return NLS.bind((String)JptJpaUiWizardsEntityGenMessages.GENERATE_ENTITIES_WIZARD_NEW_ASSOC_TABLES_PAGE_NONEXSISTENT_TABLE, (Object)this.table1TextField.getText());
        }
        if (!IterableTools.contains((Iterable)this.customizer.getTableNames(), (Object)this.table2TextField.getText())) {
            return NLS.bind((String)JptJpaUiWizardsEntityGenMessages.GENERATE_ENTITIES_WIZARD_NEW_ASSOC_TABLES_PAGE_NONEXSISTENT_TABLE, (Object)this.table2TextField.getText());
        }
        return null;
    }

    private String buildJoinTableErrorMessage() {
        if (!IterableTools.contains(this.getAllTableNames(this.customizer.getSchema()), (Object)this.joinTableTextField.getText())) {
            return NLS.bind((String)JptJpaUiWizardsEntityGenMessages.GENERATE_ENTITIES_WIZARD_NEW_ASSOC_TABLES_PAGE_NONEXSISTENT_JOIN_TABLE, (Object)this.joinTableTextField.getText());
        }
        return null;
    }

    protected ArrayList<String> getAllTableNames(Schema schema) {
        ArrayList<String> list = new ArrayList<String>();
        for (Table table : schema.getTables()) {
            list.add(table.getName());
        }
        return list;
    }
}

