/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.graphiti.editors;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.dawn.editors.IDawnEditor;
import org.eclipse.emf.cdo.dawn.editors.IDawnEditorSupport;
import org.eclipse.emf.cdo.dawn.graphiti.editors.DawnGraphitiEditorInput;
import org.eclipse.emf.cdo.dawn.graphiti.editors.DawnGraphitiEditorSupport;
import org.eclipse.emf.cdo.dawn.util.connection.CDOConnectionUtil;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.ui.editor.DefaultPersistencyBehavior;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.graphiti.ui.editor.IDiagramContainerUI;
import org.eclipse.graphiti.ui.editor.IDiagramEditorInput;
import org.eclipse.graphiti.ui.internal.services.GraphitiUiInternal;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

public class DawnGraphitiDiagramEditor
extends DiagramEditor
implements IDawnEditor {
    public static final String ID = "org.eclipse.emf.cdo.dawn.graphiti.editor";
    private IDawnEditorSupport dawnEditorSupport = new DawnGraphitiEditorSupport(this);
    private DefaultPersistencyBehavior persistencyBehavior;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (input instanceof URIEditorInput) {
            CDOConnectionUtil.instance.getCurrentSession();
            URIEditorInput uriInput = (URIEditorInput)input;
            URI diagramFileUri = uriInput.getURI();
            if (diagramFileUri != null) {
                URI diagramUri = GraphitiUiInternal.getEmfService().mapDiagramFileUriToDiagramUri(diagramFileUri);
                input = new DawnGraphitiEditorInput(diagramUri, null);
            }
        }
        super.init(site, input);
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
        IDiagramEditorInput diagramEditorInput = (IDiagramEditorInput)input;
        Diagram diagram = this.persistencyBehavior.loadDiagram(diagramEditorInput.getUri());
        Resource eResource = diagram.eResource();
        if (eResource instanceof CDOResource) {
            this.dawnEditorSupport.setView(((CDOResource)eResource).cdoView());
        }
    }

    public void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        this.dawnEditorSupport.registerListeners();
    }

    public CDOView getView() {
        return this.dawnEditorSupport.getView();
    }

    public IDawnEditorSupport getDawnEditorSupport() {
        return this.dawnEditorSupport;
    }

    public String getContributorID() {
        return ID;
    }

    public boolean isDirty() {
        return this.dawnEditorSupport.isDirty();
    }

    public void setDirty() {
        this.dawnEditorSupport.setDirty(true);
    }

    protected DiagramBehavior createDiagramBehavior() {
        DiagramBehavior diagramBehavior = new DiagramBehavior((IDiagramContainerUI)this){
            {
                this.setParentPart((IWorkbenchPart)DawnGraphitiDiagramEditor.this);
                this.initDefaultBehaviors();
            }

            protected DefaultPersistencyBehavior createPersistencyBehavior() {
                DawnGraphitiDiagramEditor.this.persistencyBehavior = new DefaultPersistencyBehavior(DawnGraphitiDiagramEditor.this.getDiagramBehavior()){

                    public void saveDiagram(IProgressMonitor monitor) {
                        (this).DawnGraphitiDiagramEditor.this.dawnEditorSupport.setDirty(false);
                        super.saveDiagram(monitor);
                    }
                };
                return DawnGraphitiDiagramEditor.this.persistencyBehavior;
            }
        };
        return diagramBehavior;
    }

    @Deprecated
    protected DefaultPersistencyBehavior createPersistencyBehavior() {
        throw new UnsupportedOperationException();
    }

    public void dispose() {
        try {
            super.dispose();
        }
        finally {
            this.dawnEditorSupport.close();
        }
    }
}

