/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstraintOwner;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTAttributeOwner;

public abstract class CPPASTConstraintOwner
extends CPPASTAttributeOwner
implements ICPPASTConstraintOwner {
    private IASTExpression[] constraintExpressions = IASTExpression.EMPTY_EXPRESSION_ARRAY;

    @Override
    protected <T extends CPPASTConstraintOwner> T copy(T copy, IASTNode.CopyStyle style) {
        IASTExpression[] iASTExpressionArray = this.getConstraintExpressions();
        int n = iASTExpressionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTExpression constraintExpression = iASTExpressionArray[n2];
            copy.addConstraintExpression(constraintExpression.copy(style));
            ++n2;
        }
        return super.copy(copy, style);
    }

    @Override
    public IASTExpression[] getConstraintExpressions() {
        this.constraintExpressions = ArrayUtil.trim(this.constraintExpressions);
        return this.constraintExpressions;
    }

    @Override
    public void addConstraintExpression(IASTExpression expression) {
        this.assertNotFrozen();
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(CONSTRAINT_SPECIFIER);
            this.constraintExpressions = ArrayUtil.append(this.constraintExpressions, expression);
        }
    }

    protected boolean acceptByConstraints(ASTVisitor action) {
        IASTExpression[] iASTExpressionArray = this.constraintExpressions;
        int n = this.constraintExpressions.length;
        int n2 = 0;
        while (n2 < n) {
            IASTExpression expr = iASTExpressionArray[n2];
            if (expr == null) break;
            if (!expr.accept(action)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return this.acceptByConstraints(visitor);
    }
}

