/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;
import org.eclipse.birt.core.archive.compound.ArchiveEntryV1;
import org.eclipse.birt.core.archive.compound.IArchiveFile;
import org.eclipse.birt.core.i18n.CoreMessages;

public class ArchiveFileV1
implements IArchiveFile {
    String archiveName;
    RandomAccessFile rf;
    private HashMap<String, Entry> lookupMap = new HashMap();

    public ArchiveFileV1(String archiveName, RandomAccessFile rf) throws IOException {
        this.archiveName = archiveName;
        this.rf = rf;
        try {
            if (this.rf == null) {
                this.rf = new RandomAccessFile(archiveName, "r");
            }
            this.readFileTable();
        }
        catch (IOException ex) {
            this.close();
            throw ex;
        }
    }

    public ArchiveFileV1(String archiveName) throws IOException {
        this(archiveName, null);
    }

    protected void readFileTable() throws IOException {
        this.rf.seek(0L);
        long streamSectionPos = this.rf.readLong();
        long entryNumber = this.rf.readLong();
        long i = 0L;
        while (i < entryNumber) {
            String name = this.rf.readUTF();
            long start = this.rf.readLong() + streamSectionPos;
            long length = this.rf.readLong();
            this.lookupMap.put(name, new Entry(name, start, length));
            ++i;
        }
    }

    @Override
    public String getName() {
        return this.archiveName;
    }

    @Override
    public String getDependId() {
        return null;
    }

    @Override
    public String getSystemId() {
        return null;
    }

    @Override
    public void close() throws IOException {
        if (this.rf != null) {
            this.rf.close();
            this.rf = null;
        }
    }

    @Override
    public void setCacheSize(long cacheSize) {
    }

    @Override
    public long getUsedCache() {
        return 0L;
    }

    @Override
    public synchronized ArchiveEntry createEntry(String name) throws IOException {
        throw new IOException(CoreMessages.getString("error.ReadOnlyArchive"));
    }

    @Override
    public boolean exists(String name) {
        return this.lookupMap.containsKey(name);
    }

    @Override
    public void flush() throws IOException {
        throw new IOException(CoreMessages.getString("error.ReadOnlyArchive"));
    }

    @Override
    public ArchiveEntry openEntry(String name) throws IOException {
        Entry entry = this.lookupMap.get(name);
        if (entry != null) {
            return new ArchiveEntryV1(this, entry.name, entry.start, entry.length);
        }
        throw new FileNotFoundException(name);
    }

    @Override
    public List<String> listEntries(String namePattern) {
        ArrayList<String> list = new ArrayList<String>();
        for (String name : this.lookupMap.keySet()) {
            if (namePattern != null && !name.startsWith(namePattern)) continue;
            list.add(name);
        }
        return list;
    }

    @Override
    public synchronized void refresh() throws IOException {
    }

    @Override
    public synchronized boolean removeEntry(String name) throws IOException {
        throw new IOException(CoreMessages.getString("error.ReadOnlyArchive"));
    }

    @Override
    public Object lockEntry(String stream) throws IOException {
        Entry entry = this.lookupMap.get(stream);
        if (entry != null) {
            return entry;
        }
        throw new FileNotFoundException("not exist stream " + stream);
    }

    @Override
    public void unlockEntry(Object locker) throws IOException {
        if (!(locker instanceof Entry)) {
            throw new IOException(CoreMessages.getFormattedString("error.InvalidLockType", locker));
        }
    }

    @Override
    public long getLength() {
        try {
            return this.rf == null ? 0L : this.rf.length();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    synchronized int read(long pos, byte[] b, int off, int len) throws IOException {
        this.rf.seek(pos);
        return this.rf.read(b, off, len);
    }

    synchronized void write(long pos, byte[] b, int off, int len) throws IOException {
        throw new IOException(CoreMessages.getString("error.ReadOnlyArchive"));
    }

    @Override
    public synchronized void save() throws IOException {
        throw new IOException(CoreMessages.getString("error.ReadOnlyArchive"));
    }

    private static class Entry {
        String name;
        long start;
        long length;

        Entry(String name, long start, long length) {
            this.name = name;
            this.start = start;
            this.length = length;
        }
    }
}

