/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.cache;

import org.eclipse.birt.core.archive.cache.Cacheable;

class CacheList {
    protected Cacheable firstEntry = null;
    protected Cacheable lastEntry = null;
    protected int listSize = 0;

    CacheList() {
    }

    void clear() {
        this.firstEntry = null;
        this.lastEntry = null;
        this.listSize = 0;
    }

    int size() {
        return this.listSize;
    }

    Cacheable first() {
        return this.firstEntry;
    }

    Cacheable last() {
        return this.lastEntry;
    }

    void remove(Cacheable entry) {
        Cacheable prev = entry.getPrev();
        Cacheable next = entry.getNext();
        entry.setPrev(null);
        entry.setNext(null);
        if (prev != null) {
            prev.setNext(next);
        } else if (entry == this.firstEntry) {
            this.firstEntry = next;
        }
        if (next != null) {
            next.setPrev(prev);
        } else if (entry == this.lastEntry) {
            this.lastEntry = prev;
        }
        --this.listSize;
    }

    Cacheable remove() {
        if (this.listSize > 0) {
            Cacheable removed = this.firstEntry;
            this.remove(removed);
            return removed;
        }
        return null;
    }

    void add(Cacheable entry) {
        entry.setPrev(this.lastEntry);
        entry.setNext(null);
        if (this.lastEntry != null) {
            this.lastEntry.setNext(entry);
        } else {
            this.firstEntry = entry;
        }
        this.lastEntry = entry;
        ++this.listSize;
    }
}

