/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.io;

import java.net.URI;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.annotation.Contract;
import org.junit.platform.commons.io.Resource;

record DefaultResource(String name, URI uri) implements Resource
{
    DefaultResource {
        DefaultResource.checkNotNull(name, "name");
        DefaultResource.checkNotNull(uri, "uri");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Resource) {
            Resource that = (Resource)obj;
            return this.name.equals(that.getName()) && this.uri.equals(that.getUri());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.uri);
    }

    @Contract(value="null, _ -> fail; !null, _ -> param1")
    private static <T> void checkNotNull(@Nullable T input, String title) {
        if (input == null) {
            throw new PreconditionViolationException(title + " must not be null");
        }
    }
}

