/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui.launcher;

import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.wst.jsdt.chromium.ConnectionLogger;
import org.eclipse.wst.jsdt.chromium.debug.core.ChromiumDebugPlugin;
import org.eclipse.wst.jsdt.chromium.debug.core.model.BreakpointSynchronizer;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ConnectionLoggerImpl;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ConsolePseudoProcess;
import org.eclipse.wst.jsdt.chromium.debug.core.model.DebugTargetImpl;
import org.eclipse.wst.jsdt.chromium.debug.core.model.IPredefinedSourceWrapProvider;
import org.eclipse.wst.jsdt.chromium.debug.core.model.JavascriptVmEmbedder;
import org.eclipse.wst.jsdt.chromium.debug.core.model.LaunchParams;
import org.eclipse.wst.jsdt.chromium.debug.core.model.NamedConnectionLoggerFactory;
import org.eclipse.wst.jsdt.chromium.debug.core.model.SourceWrapSupport;
import org.eclipse.wst.jsdt.chromium.debug.core.model.VProjectWorkspaceBridge;
import org.eclipse.wst.jsdt.chromium.debug.core.model.WorkspaceBridge;
import org.eclipse.wst.jsdt.chromium.debug.ui.PluginUtil;
import org.eclipse.wst.jsdt.chromium.debug.ui.launcher.PluginVariablesUtil;
import org.eclipse.wst.jsdt.chromium.debug.ui.listeners.JavaScriptChangeListener;
import org.eclipse.wst.jsdt.chromium.debug.ui.listeners.LaunchTerminateListener;
import org.eclipse.wst.jsdt.chromium.util.Destructable;
import org.eclipse.wst.jsdt.chromium.util.DestructingGuard;

public abstract class LaunchTypeBase
implements ILaunchConfigurationDelegate {
    static final NamedConnectionLoggerFactory NO_CONNECTION_LOGGER_FACTORY = new NamedConnectionLoggerFactory(){

        public ConnectionLogger createLogger(String title) {
            return null;
        }
    };
    private static final Runnable OPENING_VIEW_ATTACH_CALLBACK = new Runnable(){

        @Override
        public void run() {
            PluginUtil.openProjectExplorerView();
        }
    };

    public void launch(ILaunchConfiguration config, String mode, final ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (!mode.equals("debug")) {
            return;
        }
        String host = config.getAttribute("debug_host", PluginVariablesUtil.getValue("org.eclipse.wst.jsdt.chromium.debug.ui.chromium_debug_host"));
        int port = config.getAttribute("debug_port", PluginVariablesUtil.getValueAsInt("org.eclipse.wst.jsdt.chromium.debug.ui.chromium_debug_port"));
        if (host == null && port == -1) {
            throw new RuntimeException("Missing parameters in launch config");
        }
        boolean addNetworkConsole = config.getAttribute("add_network_console", false);
        SourceWrapSupport sourceWrapSupport = LaunchTypeBase.createSourceWrapSupportFromConfig(config);
        JavascriptVmEmbedder.ConnectionToRemote remoteServer = this.createConnectionToRemote(host, port, launch, addNetworkConsole);
        try {
            String projectNameBase = config.getName();
            DestructingGuard destructingGuard = new DestructingGuard();
            try {
                Destructable lauchDestructor = new Destructable(){

                    public void destruct() {
                        if (!launch.hasChildren()) {
                            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                        }
                    }
                };
                destructingGuard.addValue(lauchDestructor);
                VProjectWorkspaceBridge.FactoryImpl bridgeFactory = new VProjectWorkspaceBridge.FactoryImpl(projectNameBase);
                final DebugTargetImpl target = new DebugTargetImpl(launch, (WorkspaceBridge.Factory)bridgeFactory, sourceWrapSupport, this.getPresetSyncDirection());
                Destructable targetDestructor = new Destructable(){

                    public void destruct() {
                        LaunchTypeBase.terminateTarget(target);
                    }
                };
                destructingGuard.addValue(targetDestructor);
                launch.addDebugTarget((IDebugTarget)target);
                boolean attached = DebugTargetImpl.attach((DebugTargetImpl)target, (JavascriptVmEmbedder.ConnectionToRemote)remoteServer, (DestructingGuard)destructingGuard, (Runnable)OPENING_VIEW_ATTACH_CALLBACK, (IProgressMonitor)monitor);
                if (!attached) {
                    return;
                }
                launch.addDebugTarget((IDebugTarget)target);
                monitor.done();
                this.addListeners(launch);
                destructingGuard.discharge();
            }
            finally {
                destructingGuard.doFinally();
            }
        }
        finally {
            remoteServer.disposeConnection();
        }
    }

    protected abstract JavascriptVmEmbedder.ConnectionToRemote createConnectionToRemote(String var1, int var2, ILaunch var3, boolean var4) throws CoreException;

    protected abstract BreakpointSynchronizer.Direction getPresetSyncDirection();

    private static void terminateTarget(DebugTargetImpl target) {
        try {
            target.terminate();
        }
        catch (DebugException e) {
            ChromiumDebugPlugin.log((Throwable)e);
        }
    }

    private void addListeners(ILaunch launch) {
        JavaScriptChangeListener listener = new JavaScriptChangeListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)new LaunchTerminateListener(launch, listener));
    }

    static ConnectionLogger createConsoleAndLogger(final ILaunch launch, final boolean addLaunchToManager, final String title) {
        final ConsolePseudoProcess.Retransmitter consoleRetransmitter = new ConsolePseudoProcess.Retransmitter();
        ConnectionLoggerImpl.LogLifecycleListener consoleController = new ConnectionLoggerImpl.LogLifecycleListener(){
            private final AtomicBoolean alreadyStarted = new AtomicBoolean(false);

            public void logClosed() {
                consoleRetransmitter.processClosed();
            }

            public void logStarted(ConnectionLoggerImpl connectionLogger) {
                boolean res = this.alreadyStarted.compareAndSet(false, true);
                if (!res) {
                    throw new IllegalStateException();
                }
                new ConsolePseudoProcess(launch, title, consoleRetransmitter, connectionLogger.getConnectionTerminate());
                consoleRetransmitter.startFlushing();
                if (addLaunchToManager) {
                    DebugPlugin.getDefault().getLaunchManager().addLaunch(launch);
                }
            }
        };
        return new ConnectionLoggerImpl((Writer)consoleRetransmitter, consoleController);
    }

    private static SourceWrapSupport createSourceWrapSupportFromConfig(ILaunchConfiguration config) throws CoreException {
        List entries = LaunchParams.PredefinedSourceWrapperIds.resolveEntries((ILaunchConfiguration)config);
        ArrayList<SourceWrapSupport.Wrapper> wrappers = new ArrayList<SourceWrapSupport.Wrapper>(entries.size());
        for (IPredefinedSourceWrapProvider.Entry en : entries) {
            wrappers.add(en.getWrapper());
        }
        return new SourceWrapSupport(wrappers);
    }
}

