/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.util;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.css.core.internal.util.URLModelProviderCSS;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;

public class CSSPathService {
    private static final String FILEURLSCHEME = "file";
    private static final String URLCOLON = ":";
    private static final String FILEURLPREFIX = "file://";
    private static final String URLSEPARATOR = "/";

    public static String getAbsoluteURL(IStructuredModel baseModel, String ref) {
        String url;
        block3: {
            String absLink;
            url = absLink = URLModelProviderCSS.resolveURI(baseModel, ref, true);
            if (absLink != null) {
                try {
                    new URL(absLink);
                }
                catch (MalformedURLException malformedURLException) {
                    Path path = new Path(absLink);
                    if (path == null) break block3;
                    url = CSSPathService.toURL((IPath)path);
                }
            }
        }
        return url;
    }

    public static IFile location2File(String location) {
        Path path = new Path(location);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
        if (file == null && path.segmentCount() > 1) {
            file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        }
        return file;
    }

    private static String toURL(IPath path) {
        if ((path = new Path(path.toFile().getAbsolutePath())).isUNC()) {
            return "file:" + path.toString();
        }
        return "file:///" + path.toString();
    }
}

