/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.lttng2.control.ui.Activator;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.IAddContextDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages;

public class AddContextDialog
extends Dialog
implements IAddContextDialog {
    public static final String ADD_CONTEXT_ICON_FILE = "icons/elcl16/add-context.gif";
    private CheckboxTreeViewer fContextsViewer;
    private final ContextModel fContextModel = new ContextModel();
    private final List<String> fSelectedContexts = new ArrayList<String>();

    public AddContextDialog(Shell shell) {
        super(shell);
        this.setShellStyle(0x10 | this.getShellStyle());
    }

    @Override
    public void setAvalibleContexts(List<String> contexts) {
        this.fContextModel.setAvalibleContexts(contexts);
    }

    @Override
    public List<String> getContexts() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.addAll(this.fSelectedContexts);
        return ret;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.TraceControl_AddContextDialogTitle);
        newShell.setImage(Activator.getDefault().loadIcon(ADD_CONTEXT_ICON_FILE));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        dialogComposite.setLayout((Layout)layout);
        dialogComposite.setLayoutData((Object)new GridData(1808));
        Group contextGroup = new Group(dialogComposite, 32);
        contextGroup.setText(Messages.TraceControl_AddContextAvailableContextsLabel);
        layout = new GridLayout(1, true);
        contextGroup.setLayout((Layout)layout);
        contextGroup.setLayoutData((Object)new GridData(1808));
        this.fContextsViewer = new CheckboxTreeViewer((Composite)contextGroup, 770);
        this.fContextsViewer.getTree().setToolTipText(Messages.TraceControl_AddContextAvailableContextsTooltip);
        this.fContextsViewer.setContentProvider((IContentProvider)new ContextsContentProvider());
        this.fContextsViewer.setLabelProvider((IBaseLabelProvider)new ContextsLabelProvider());
        this.fContextsViewer.addCheckStateListener((ICheckStateListener)new ContextCheckListener());
        this.fContextsViewer.setInput((Object)this.fContextModel);
        this.fContextsViewer.getTree().setLayoutData((Object)new GridData(1808));
        this.getShell().setMinimumSize(new Point(500, 450));
        return dialogComposite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, "&Cancel", true);
        this.createButton(parent, 0, "&Ok", true);
    }

    protected void okPressed() {
        this.fSelectedContexts.clear();
        Object[] checkedElements = this.fContextsViewer.getCheckedElements();
        int i = 0;
        while (i < checkedElements.length) {
            IContextModelComponent component = (IContextModelComponent)checkedElements[i];
            if (!Messages.TraceControl_AddContextAllLabel.equals(component.getName())) {
                this.fSelectedContexts.add(component.getName());
            }
            ++i;
        }
        super.okPressed();
    }

    public static class AllContexts
    implements IContextModelComponent {
        private List<Context> fAvailableContexts;
        private final IContextModelComponent fParent;

        public AllContexts(IContextModelComponent parent) {
            this.fParent = parent;
        }

        public void setAvalibleContexts(List<String> contexts) {
            this.fAvailableContexts = new ArrayList<Context>();
            if (contexts != null) {
                for (String name : contexts) {
                    this.fAvailableContexts.add(new Context(this, name));
                }
            }
        }

        @Override
        public String getName() {
            return Messages.TraceControl_AddContextAllLabel;
        }

        @Override
        public Object[] getChildren() {
            return this.fAvailableContexts.toArray();
        }

        @Override
        public Object getParent() {
            return this.fParent;
        }

        @Override
        public boolean hasChildren() {
            return true;
        }
    }

    public static class Context
    implements IContextModelComponent {
        private final String fContextName;
        private final IContextModelComponent fParent;

        public Context(IContextModelComponent parent, String name) {
            this.fParent = parent;
            this.fContextName = name;
        }

        @Override
        public String getName() {
            return this.fContextName;
        }

        @Override
        public Object getParent() {
            return this.fParent;
        }

        @Override
        public Object[] getChildren() {
            return null;
        }

        @Override
        public boolean hasChildren() {
            return false;
        }
    }

    public final class ContextCheckListener
    implements ICheckStateListener {
        public void checkStateChanged(CheckStateChangedEvent event) {
            if (event.getChecked()) {
                if (event.getElement() instanceof AllContexts) {
                    AddContextDialog.this.fContextsViewer.setSubtreeChecked(event.getElement(), true);
                }
            } else if (event.getElement() instanceof AllContexts) {
                AddContextDialog.this.fContextsViewer.setSubtreeChecked(event.getElement(), false);
            } else {
                IContextModelComponent component = (IContextModelComponent)event.getElement();
                AddContextDialog.this.fContextsViewer.setChecked(component.getParent(), false);
            }
        }
    }

    public static class ContextModel
    implements IContextModelComponent {
        private final AllContexts fAllContexts = new AllContexts(this);

        public void setAvalibleContexts(List<String> contexts) {
            this.fAllContexts.setAvalibleContexts(contexts);
        }

        @Override
        public String getName() {
            return "root";
        }

        @Override
        public Object getParent() {
            return null;
        }

        @Override
        public Object[] getChildren() {
            Object[] ret = new Object[]{this.fAllContexts};
            return ret;
        }

        @Override
        public boolean hasChildren() {
            return true;
        }
    }

    public static final class ContextsContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IContextModelComponent) {
                return ((IContextModelComponent)parentElement).getChildren();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof IContextModelComponent) {
                return ((IContextModelComponent)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IContextModelComponent) {
                return ((IContextModelComponent)element).hasChildren();
            }
            return false;
        }
    }

    public static final class ContextsLabelProvider
    extends ColumnLabelProvider {
        public String getText(Object element) {
            if (element != null && element instanceof IContextModelComponent) {
                return ((IContextModelComponent)element).getName();
            }
            return "";
        }
    }

    public static interface IContextModelComponent {
        public String getName();

        public Object getParent();

        public Object[] getChildren();

        public boolean hasChildren();
    }
}

