/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.menu;

import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Optional;
import org.eclipse.sirius.diagram.ui.provider.Messages;

public class LocationURI {
    public static final String MENU_SCHEME = "menu";
    public static final String TABBAR_SCHEME = "tabbar";
    public static final String LOCATION_SEPARATOR = "|";
    public static final String SEPARATOR = ":";
    public static final String ROOT_MENU_ID = "root";
    private String string;
    private String menuId;
    private String tabbarId;

    public LocationURI(String locationURI) throws URISyntaxException {
        this.string = locationURI;
        this.parse();
    }

    public Optional<String> getMenuId() {
        return Optional.ofNullable(this.menuId);
    }

    public Optional<String> getTabbarId() {
        return Optional.ofNullable(this.tabbarId);
    }

    private void parse() throws URISyntaxException {
        if (this.string.trim().length() == 0) {
            throw new URISyntaxException(this.string, MessageFormat.format(Messages.LocationURI_ParsePb_Blank, MENU_SCHEME, TABBAR_SCHEME));
        }
        String[] locationsURI = this.string.split("\\|");
        if (locationsURI.length > 2) {
            throw new URISyntaxException(this.string, MessageFormat.format(Messages.LocationURI_ParsePb_MoreThanTwoLocations, LOCATION_SEPARATOR, locationsURI.length));
        }
        int i = 0;
        while (i < locationsURI.length) {
            String trimmedURI = locationsURI[i].trim();
            if (trimmedURI.startsWith(MENU_SCHEME)) {
                this.parseMenuURI(trimmedURI);
            } else if (trimmedURI.startsWith(TABBAR_SCHEME)) {
                this.parseTabbarURI(trimmedURI);
            } else {
                throw new URISyntaxException(this.string, MessageFormat.format(Messages.LocationURI_ParsePb_WrongScheme, MENU_SCHEME, TABBAR_SCHEME));
            }
            ++i;
        }
    }

    private void parseMenuURI(String menuURI) throws URISyntaxException {
        if (this.menuId != null) {
            throw new URISyntaxException(this.string, MessageFormat.format(Messages.LocationURI_ParsePb_OnlyOneLocationURIPerScheme, MENU_SCHEME));
        }
        if (menuURI.substring(MENU_SCHEME.length()).trim().startsWith(SEPARATOR)) {
            String id = menuURI.substring(MENU_SCHEME.length()).trim().substring(SEPARATOR.length()).trim();
            if (id.length() == 0) {
                throw new URISyntaxException(this.string, MessageFormat.format(Messages.LocationURI_ParsePb_NoId, "menu:"));
            }
            this.menuId = id;
        } else if (menuURI.length() == MENU_SCHEME.length()) {
            this.menuId = ROOT_MENU_ID;
        } else {
            throw new URISyntaxException(this.string, MessageFormat.format(Messages.LocationURI_ParsePb_WrongFormat, "menu:menuId", menuURI));
        }
    }

    private void parseTabbarURI(String tabbarURI) throws URISyntaxException {
        String id;
        if (this.tabbarId != null) {
            throw new URISyntaxException(this.string, MessageFormat.format(Messages.LocationURI_ParsePb_OnlyOneLocationURIPerScheme, TABBAR_SCHEME));
        }
        if (tabbarURI.substring(TABBAR_SCHEME.length()).trim().startsWith(SEPARATOR)) {
            id = tabbarURI.substring(TABBAR_SCHEME.length()).trim().substring(SEPARATOR.length()).trim();
            if (id.length() == 0) {
                throw new URISyntaxException(this.string, MessageFormat.format(Messages.LocationURI_ParsePb_NoId, "tabbar:"));
            }
        } else {
            throw new URISyntaxException(this.string, MessageFormat.format(Messages.LocationURI_ParsePb_WrongFormat, "tabbar:tabbarId", tabbarURI));
        }
        this.tabbarId = id;
    }
}

