/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.widgets.celleditors.ecore.composite;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.modisco.facet.widgets.celleditors.IValidator;
import org.eclipse.modisco.facet.widgets.celleditors.ecore.composite.StringComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class LongComposite
extends StringComposite<Long> {
    public LongComposite(Composite parent) {
        this(parent, 0);
    }

    public LongComposite(Composite parent, int style) {
        super(parent, style);
        this.getTextField().addListener(25, new Listener(){

            public void handleEvent(Event event) {
                String input = event.text;
                int i = 0;
                while (i < input.length()) {
                    char ch = input.charAt(i);
                    if (ch != '-') {
                        if ('0' > ch || ch > '9') {
                            event.doit = false;
                            return;
                        }
                    } else {
                        if (LongComposite.this.getTextField().getText().indexOf(45) != -1) {
                            event.doit = false;
                            return;
                        }
                        if (event.start != 0) {
                            event.doit = false;
                            return;
                        }
                    }
                    ++i;
                }
            }
        });
    }

    public IValidator getValidator() {
        return new IValidator(){

            public IStatus validate(Object object) {
                if (LongComposite.this.getValue() != null && Long.MIN_VALUE <= (Long)LongComposite.this.getValue() && (Long)LongComposite.this.getValue() <= Long.MAX_VALUE) {
                    return Status.OK_STATUS;
                }
                return new Status(4, "org.eclipse.modisco.facet.widgets.celleditors", "");
            }
        };
    }

    @Override
    public StringComposite.IConverter<Long> initConverter() {
        return new StringComposite.IConverter<Long>(){

            @Override
            public Long toObject(String string) {
                if (string != null && string.length() > 0) {
                    try {
                        return new Long(string);
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
                return null;
            }

            @Override
            public String toString(Long object) {
                return object.toString();
            }
        };
    }

    @Override
    public IStatus validate(String string) {
        try {
            if (string.length() > 0) {
                Long.parseLong(string);
            }
        }
        catch (Exception e) {
            return new Status(4, "org.eclipse.modisco.facet.widgets.celleditors", "");
        }
        return new Status(0, "org.eclipse.modisco.facet.widgets.celleditors", "");
    }
}

