/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot.actions;

import java.math.BigInteger;
import java.util.regex.Pattern;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.OQL;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.QueryExecution;
import org.eclipse.mat.ui.snapshot.editor.HeapEditor;
import org.eclipse.mat.ui.snapshot.editor.ISnapshotEditorInput;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class OpenObjectByIdAction
extends Action {
    public OpenObjectByIdAction() {
        super(Messages.OpenObjectByIdAction_FindObjectByAddress, MemoryAnalyserPlugin.getImageDescriptor("$nl$/icons/find.gif"));
    }

    public void run() {
        IEditorPart part;
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart iEditorPart = part = page == null ? null : page.getActiveEditor();
        if (part instanceof HeapEditor) {
            HeapEditor editor = (HeapEditor)part;
            String value = this.askForAddress();
            if (value != null) {
                this.retrieveObjectAndOpenPane(editor, value);
            }
        }
    }

    private void retrieveObjectAndOpenPane(HeapEditor editor, String value) {
        String errorMessage;
        block11: {
            errorMessage = null;
            try {
                int objectId;
                long objectAddress = new BigInteger(value.substring(2), 16).longValue();
                ISnapshot snapshot = ((ISnapshotEditorInput)editor.getPaneEditorInput()).getSnapshot();
                if (snapshot == null) {
                    errorMessage = Messages.OpenObjectByIdAction_ErrorGettingHeapDump;
                    break block11;
                }
                try {
                    objectId = snapshot.mapAddressToId(objectAddress);
                }
                catch (SnapshotException e) {
                    objectId = -1;
                }
                if (objectId < 0) {
                    ObjectReference ref = new ObjectReference(snapshot, objectAddress);
                    try {
                        IObject obj = ref.getObject();
                        objectAddress = obj.getObjectAddress();
                    }
                    catch (SnapshotException e) {
                        errorMessage = MessageUtil.format((String)Messages.OpenObjectByIdAction_NoObjectWithAddress, (Object[])new Object[]{value});
                    }
                    if (errorMessage == null) {
                        QueryExecution.executeCommandLine(editor, null, "oql \"" + OQL.forAddress((long)objectAddress) + "\"");
                    }
                    break block11;
                }
                QueryExecution.executeCommandLine(editor, null, "list_objects " + value);
            }
            catch (NumberFormatException e) {
                errorMessage = Messages.OpenObjectByIdAction_AddressIsNotHexNumber;
            }
            catch (SnapshotException e) {
                errorMessage = MessageUtil.format((String)Messages.OpenObjectByIdAction_ErrorReadingObject, (Object[])new Object[]{e.getMessage()});
            }
        }
        if (errorMessage != null) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.OpenObjectByIdAction_ErrorOpeningObject, (String)errorMessage);
        }
    }

    private String askForAddress() {
        final Pattern pattern = Pattern.compile("^0x\\p{XDigit}+$");
        InputDialog dialog = new InputDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.OpenObjectByIdAction_FindObjectByAddress, Messages.OpenObjectByIdAction_ObjectAddress, "0x", new IInputValidator(){

            public String isValid(String newText) {
                return !pattern.matcher(newText).matches() ? Messages.OpenObjectByIdAction_AddressMustBeHexNumber : null;
            }
        });
        int result = dialog.open();
        String value = dialog.getValue();
        if (result == 1) {
            return null;
        }
        return value;
    }
}

