/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.consumption.ui.widgets;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.AbstractObjectSelectionLaunchable;
import org.eclipse.jst.ws.internal.cxf.consumption.ui.CXFConsumptionUIMessages;
import org.eclipse.jst.ws.internal.cxf.consumption.ui.CXFConsumptionUIPlugin;
import org.eclipse.jst.ws.jaxws.core.utils.JDTUtils;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class CXFJAXWSSelectionLaunchable
extends AbstractObjectSelectionLaunchable {
    private IStatus validationStatus = Status.OK_STATUS;
    private IProject project;
    private String serverComponentName;
    private String className = "";

    public void setInitialSelection(IStructuredSelection initialSelection) {
        Object firstElement;
        if (initialSelection != null && !initialSelection.isEmpty() && (firstElement = initialSelection.getFirstElement()) instanceof String) {
            this.className = firstElement.toString();
        }
    }

    public int launch(Shell shell) {
        IStatus status = Status.OK_STATUS;
        ElementTreeSelectionDialog selectionDialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)new JavaElementLabelProvider(), (ITreeContentProvider)new StandardJavaElementContentProvider());
        selectionDialog.setTitle(CXFConsumptionUIMessages.CXFJAXWSSELECTIONLAUNCHABLE_SELECTION_DIALOG_TITLE);
        selectionDialog.setMessage(CXFConsumptionUIMessages.CXFJAXWSSELECTIONLAUNCHABLE_SELECTION_DIALOG_MESSAGE);
        selectionDialog.setAllowMultiple(false);
        selectionDialog.setInput((Object)JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
        selectionDialog.addFilter((ViewerFilter)new JavaViewerFilter());
        selectionDialog.setValidator((ISelectionStatusValidator)new JavaSelectionStatusValidator());
        int returnCode = selectionDialog.open();
        if (returnCode == 0) {
            ICompilationUnit selectedCompilationUnit = (ICompilationUnit)selectionDialog.getFirstResult();
            IType type = selectedCompilationUnit.findPrimaryType();
            this.className = type.getFullyQualifiedName();
            try {
                IResource typeResource = type.getUnderlyingResource();
                if (typeResource != null) {
                    this.project = typeResource.getProject();
                    IVirtualComponent comp = ResourceUtils.getComponentOf((IResource)typeResource);
                    if (comp != null) {
                        this.serverComponentName = comp.getName();
                    }
                } else {
                    this.project = null;
                    this.serverComponentName = null;
                }
                return status.getSeverity();
            }
            catch (JavaModelException jme) {
                this.project = null;
                this.serverComponentName = null;
                status = jme.getStatus();
                CXFConsumptionUIPlugin.log(status);
                return status.getSeverity();
            }
        }
        return 8;
    }

    public IStructuredSelection getObjectSelection() {
        return new StructuredSelection((Object)this.className);
    }

    public String getComponentName() {
        return this.serverComponentName;
    }

    public IProject getProject() {
        TreeSelection treeSelection;
        Object firstElement;
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        ISelection selection = selectionService.getSelection();
        if (selection != null && !selection.isEmpty() && selection instanceof TreeSelection && (firstElement = (treeSelection = (TreeSelection)selection).getFirstElement()) instanceof ICompilationUnit) {
            ICompilationUnit compilationUnit = (ICompilationUnit)firstElement;
            this.project = compilationUnit.getResource().getProject();
        }
        return this.project;
    }

    public IStatus validateSelection(IStructuredSelection objectSelection) {
        return this.validationStatus;
    }

    public String getObjectSelectionDisplayableString() {
        return this.className;
    }

    public boolean validate(String stringToValidate) {
        this.className = stringToValidate;
        IProject project = this.getProject();
        this.validationStatus = project != null ? JDTUtils.validateJavaTypeName((String)project.getName(), (String)this.className) : JDTUtils.validateJavaTypeName((String)this.className);
        return this.validationStatus.isOK();
    }

    private static class JavaSelectionStatusValidator
    implements ISelectionStatusValidator {
        private JavaSelectionStatusValidator() {
        }

        public IStatus validate(Object[] selection) {
            if (selection.length == 1 && selection[0] instanceof ICompilationUnit) {
                return new Status(0, "org.eclipse.jst.ws.cxf.consumption.ui", "");
            }
            return new Status(4, "org.eclipse.jst.ws.cxf.consumption.ui", "");
        }
    }

    private static class JavaViewerFilter
    extends ViewerFilter {
        private JavaViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            block6: {
                if (!(element instanceof IJavaProject)) break block6;
                return true;
            }
            try {
                if (element instanceof IPackageFragmentRoot) {
                    IPackageFragmentRoot packageFragmentRoot = (IPackageFragmentRoot)element;
                    return packageFragmentRoot.getKind() == 1;
                }
                if (element instanceof IPackageFragment) {
                    IPackageFragment packageFragment = (IPackageFragment)element;
                    return packageFragment.hasChildren();
                }
                if (element instanceof ICompilationUnit) {
                    ICompilationUnit compilationUnit = (ICompilationUnit)element;
                    IType type = compilationUnit.findPrimaryType();
                    return type.isClass() || type.isInterface();
                }
            }
            catch (JavaModelException jme) {
                CXFConsumptionUIPlugin.log(jme.getStatus());
            }
            return false;
        }
    }
}

