/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.internal.annotations.ui;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jst.common.internal.annotations.registry.AttributeValueProposalHelper;
import org.eclipse.jst.common.internal.annotations.ui.AbstractAnnotationTagProposal;
import org.eclipse.jst.common.internal.annotations.ui.UIAttributeValueProposalHelper;
import org.eclipse.swt.graphics.Image;

public class AnnotationTagProposal
extends AbstractAnnotationTagProposal
implements IJavaCompletionProposal,
ICompletionProposalExtension,
ICompletionProposalExtension2 {
    private static final char QUOTE = '\"';
    private boolean ensureBeginQuote = false;
    private boolean ensureEndQuote = false;
    private String localString;
    private String fValidationString;
    private String locText;

    public AnnotationTagProposal(String replacementString, int replacementOffset, int replacementLength, Image image, String displayString, int relevance) {
        Assert.isNotNull((Object)replacementString);
        Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
        Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
        this.setReplacementString(replacementString);
        this.setReplacementOffset(replacementOffset);
        this.setReplacementLength(replacementLength);
        this.setImage(image);
        this.setDisplayString(displayString == null ? replacementString : displayString);
        this.setRelevance(relevance);
        this.setCursorPosition(replacementString.length());
        this.setSortString(displayString == null ? replacementString : displayString);
        this.localString = replacementString;
    }

    public AnnotationTagProposal(AttributeValueProposalHelper proposalHelper) {
        this(proposalHelper.getReplacementString(), proposalHelper.getValueOffset(), proposalHelper.getReplacementLength(), null, proposalHelper.getValueDisplayString(), 90);
        if (proposalHelper instanceof UIAttributeValueProposalHelper) {
            this.setImage(((UIAttributeValueProposalHelper)proposalHelper).getImage());
        }
        this.setEnsureBeginQuote(proposalHelper.ensureBeginQuote());
        this.setEnsureEndQuote(proposalHelper.ensureEndQuote());
    }

    public AnnotationTagProposal(UIAttributeValueProposalHelper proposalHelper) {
        this(proposalHelper.getReplacementString(), proposalHelper.getValueOffset(), proposalHelper.getReplacementLength(), proposalHelper.getImage(), proposalHelper.getValueDisplayString(), 90);
        this.setEnsureBeginQuote(proposalHelper.ensureBeginQuote());
        this.setEnsureEndQuote(proposalHelper.ensureEndQuote());
    }

    @Override
    public String getAdditionalProposalInfo() {
        return this.locText;
    }

    public void setHelpText(String s) {
        this.locText = s;
    }

    @Override
    public void apply(IDocument document, char trigger, int offset) {
        this.ensureQuotedIfNecessary(document, offset);
        super.apply(document, trigger, offset);
    }

    private void ensureQuotedIfNecessary(IDocument document, int offset) {
        if (this.ensureBeginQuote || this.ensureEndQuote) {
            try {
                char begin = document.getChar(this.getReplacementOffset() - 1);
                char end = document.getChar(offset);
                if (this.ensureBeginQuote && this.ensureEndQuote && begin != '\"' && end != '\"') {
                    StringBuffer b = new StringBuffer();
                    b.append('\"').append(this.localString).append('\"');
                    this.localString = b.toString();
                } else if (this.ensureBeginQuote && begin != '\"') {
                    this.localString = String.valueOf('\"') + this.localString;
                } else if (this.ensureEndQuote && end != '\"') {
                    this.localString = String.valueOf(this.localString) + '\"';
                }
                this.setReplacementString(this.localString);
                this.setCursorPosition(this.localString.length());
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    public void setEnsureQuoted(boolean ensureQuoted) {
        this.setEnsureBeginQuote(ensureQuoted);
        this.setEnsureEndQuote(ensureQuoted);
    }

    public void setEnsureBeginQuote(boolean ensureBeginQuote) {
        this.ensureBeginQuote = ensureBeginQuote;
    }

    public void setEnsureEndQuote(boolean ensureEndQuote) {
        this.ensureEndQuote = ensureEndQuote;
    }

    @Override
    protected boolean isValidPrefix(String prefix) {
        if (this.getReplacementString().startsWith(this.getDisplayString())) {
            return super.isValidPrefix(prefix);
        }
        return super.isPrefix(this.trim(prefix), this.getValidationString());
    }

    private String getValidationString() {
        if (this.fValidationString == null) {
            this.fValidationString = this.trim(this.getReplacementString());
        }
        return this.fValidationString;
    }

    private String trim(String aString) {
        if (aString == null || aString.length() == 0) {
            return aString;
        }
        StringBuffer buffer = new StringBuffer();
        char[] chars = aString.toCharArray();
        int i = chars.length - 1;
        while (i > -1) {
            if (Character.isWhitespace(chars[i])) break;
            buffer.append(chars[i]);
            --i;
        }
        buffer = buffer.reverse();
        return buffer.toString();
    }
}

