/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value.swing;

import java.io.Serializable;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;

public abstract class AbstractTreeModel
implements TreeModel,
Serializable {
    protected final EventListenerList listenerList = new EventListenerList();
    private static final long serialVersionUID = 1L;

    protected AbstractTreeModel() {
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(TreeModelListener.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
    }

    public TreeModelListener[] treeModelListeners() {
        return (TreeModelListener[])this.listenerList.getListeners(TreeModelListener.class);
    }

    protected boolean hasNoTreeModelListeners() {
        return this.listenerList.getListenerCount(TreeModelListener.class) == 0;
    }

    protected boolean hasTreeModelListeners() {
        return !this.hasNoTreeModelListeners();
    }

    protected void fireTreeNodesChanged(Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent event = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == TreeModelListener.class) {
                if (event == null) {
                    event = new TreeModelEvent((Object)this, path, childIndices, children);
                }
                ((TreeModelListener)listeners[i + 1]).treeNodesChanged(event);
            }
            i -= 2;
        }
    }

    protected void fireTreeNodeChanged(Object[] path, int childIndex, Object child) {
        this.fireTreeNodesChanged(path, new int[]{childIndex}, new Object[]{child});
    }

    protected void fireTreeRootChanged(Object root) {
        this.fireTreeNodesChanged(new Object[]{root}, null, null);
    }

    protected void fireTreeNodesInserted(Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent event = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == TreeModelListener.class) {
                if (event == null) {
                    event = new TreeModelEvent((Object)this, path, childIndices, children);
                }
                ((TreeModelListener)listeners[i + 1]).treeNodesInserted(event);
            }
            i -= 2;
        }
    }

    protected void fireTreeNodeInserted(Object[] path, int childIndex, Object child) {
        this.fireTreeNodesInserted(path, new int[]{childIndex}, new Object[]{child});
    }

    protected void fireTreeNodesRemoved(Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent event = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == TreeModelListener.class) {
                if (event == null) {
                    event = new TreeModelEvent((Object)this, path, childIndices, children);
                }
                ((TreeModelListener)listeners[i + 1]).treeNodesRemoved(event);
            }
            i -= 2;
        }
    }

    protected void fireTreeNodeRemoved(Object[] path, int childIndex, Object child) {
        this.fireTreeNodesRemoved(path, new int[]{childIndex}, new Object[]{child});
    }

    protected void fireTreeStructureChanged(Object[] path) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent event = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == TreeModelListener.class) {
                if (event == null) {
                    event = new TreeModelEvent((Object)this, path);
                }
                ((TreeModelListener)listeners[i + 1]).treeStructureChanged(event);
            }
            i -= 2;
        }
    }

    protected void fireTreeRootReplaced(Object newRoot) {
        this.fireTreeStructureChanged(new Object[]{newRoot});
    }
}

