/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.swt.bindings;

import java.util.ArrayList;
import org.eclipse.jpt.common.ui.internal.swt.bindings.ListWidgetModelBinding;
import org.eclipse.jpt.common.ui.internal.swt.events.SelectionAdapter;
import org.eclipse.jpt.common.ui.internal.swt.listeners.SWTListenerTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;

abstract class AbstractComboSelectionBinding<E, CA extends ComboAdapter>
implements ListWidgetModelBinding.SelectionBinding {
    final ArrayList<E> list;
    final ModifiablePropertyValueModel<E> valueModel;
    final PropertyChangeListener valueListener;
    final CA combo;
    final SelectionListener comboSelectionListener;

    AbstractComboSelectionBinding(ArrayList<E> list, ModifiablePropertyValueModel<E> valueModel, CA combo) {
        if (list == null || valueModel == null || combo == null) {
            throw new NullPointerException();
        }
        this.list = list;
        this.valueModel = valueModel;
        this.combo = combo;
        this.valueListener = this.buildValueListener();
        this.valueModel.addPropertyChangeListener("value", this.valueListener);
        this.comboSelectionListener = this.buildComboSelectionListener();
        this.combo.addSelectionListener(this.comboSelectionListener);
    }

    private PropertyChangeListener buildValueListener() {
        return SWTListenerTools.wrap((PropertyChangeListener)new ValueListener(), this.combo.getDisplay());
    }

    private SelectionListener buildComboSelectionListener() {
        return new ComboSelectionListener();
    }

    void valueChanged(PropertyChangeEvent event) {
        if (!this.combo.isDisposed()) {
            Object item = event.getNewValue();
            this.valueChanged_(item);
        }
    }

    abstract void valueChanged_(E var1);

    void comboSelectionChanged() {
        this.valueModel.setValue(this.getComboSelectedItem());
    }

    void comboDoubleClicked() {
        this.comboSelectionChanged();
    }

    private E getComboSelectedItem() {
        int index = this.combo.getSelectionIndex();
        return index == -1 ? null : (E)this.list.get(index);
    }

    @Override
    public void dispose() {
        this.combo.removeSelectionListener(this.comboSelectionListener);
        this.valueModel.removePropertyChangeListener("value", this.valueListener);
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.valueModel);
    }

    static interface ComboAdapter {
        public Display getDisplay();

        public boolean isDisposed();

        public void addSelectionListener(SelectionListener var1);

        public void removeSelectionListener(SelectionListener var1);

        public int getSelectionIndex();
    }

    class ComboSelectionListener
    extends SelectionAdapter {
        ComboSelectionListener() {
        }

        @Override
        public void widgetSelected(SelectionEvent event) {
            AbstractComboSelectionBinding.this.comboSelectionChanged();
        }

        @Override
        public void widgetDefaultSelected(SelectionEvent event) {
            AbstractComboSelectionBinding.this.comboDoubleClicked();
        }
    }

    class ValueListener
    extends PropertyChangeAdapter {
        ValueListener() {
        }

        public void propertyChanged(PropertyChangeEvent event) {
            AbstractComboSelectionBinding.this.valueChanged(event);
        }
    }
}

