/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.jdt.internal.compiler.env.IBinaryElementValuePair;
import org.eclipse.jdt.internal.compiler.env.IElementInfo;
import org.eclipse.jdt.internal.core.AnnotationInfo;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.MemberValuePair;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.eclipse.jdt.internal.core.SourceRefElement;
import org.eclipse.jdt.internal.core.util.Util;

public class Annotation
extends SourceRefElement
implements IAnnotation {
    public static final IAnnotation[] NO_ANNOTATIONS = new IAnnotation[0];
    public static final IMemberValuePair[] NO_MEMBER_VALUE_PAIRS = new IMemberValuePair[0];
    protected final String name;
    protected final String memberValuePairName;

    public Annotation(JavaElement parent, String name) {
        this(parent, name, null);
    }

    public Annotation(JavaElement parent, String name, String memberValuePairName) {
        this(parent, name, memberValuePairName, 1);
    }

    public Annotation(JavaElement parent, String name, String memberValuePairName, int occurrenceCount) {
        super(parent, occurrenceCount);
        this.name = name.intern();
        this.memberValuePairName = memberValuePairName;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object o) {
        void other;
        if (!(o instanceof Annotation)) {
            return false;
        }
        Annotation annotation = (Annotation)o;
        if (this.memberValuePairName == null ? other.memberValuePairName != null : !this.memberValuePairName.equals(other.memberValuePairName)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected int calculateHashCode() {
        return Util.combineHashCodes(super.calculateHashCode(), this.memberValuePairName == null ? 0 : this.memberValuePairName.hashCode());
    }

    public IMember getDeclaringMember() {
        return (IMember)((Object)this.getParent());
    }

    @Override
    public String getElementName() {
        return this.name;
    }

    @Override
    public int getElementType() {
        return 16;
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '}';
    }

    @Override
    public IMemberValuePair[] getMemberValuePairs() throws JavaModelException {
        IElementInfo info = this.getElementInfo();
        if (info instanceof AnnotationInfo) {
            return ((AnnotationInfo)info).members;
        }
        IBinaryElementValuePair[] binaryAnnotations = ((IBinaryAnnotation)info).getElementValuePairs();
        int length = binaryAnnotations.length;
        IMemberValuePair[] result = new IMemberValuePair[length];
        int i = 0;
        while (i < length) {
            IBinaryElementValuePair binaryAnnotation = binaryAnnotations[i];
            MemberValuePair memberValuePair = new MemberValuePair(new String(binaryAnnotation.getName()));
            memberValuePair.value = Util.getAnnotationMemberValue(this, memberValuePair, binaryAnnotation.getValue());
            result[i] = memberValuePair;
            ++i;
        }
        return result;
    }

    @Override
    public ISourceRange getNameRange() throws JavaModelException {
        IClassFile classFile;
        SourceMapper mapper = this.getSourceMapper();
        if (mapper != null && (classFile = this.getClassFile()) != null) {
            classFile.getBuffer();
            return mapper.getNameRange(this);
        }
        IElementInfo info = this.getElementInfo();
        if (info instanceof AnnotationInfo) {
            AnnotationInfo annotationInfo = (AnnotationInfo)info;
            return new SourceRange(annotationInfo.nameStart, annotationInfo.nameEnd - annotationInfo.nameStart + 1);
        }
        return null;
    }

    @Override
    public ISourceRange getSourceRange() throws JavaModelException {
        IClassFile classFile;
        SourceMapper mapper = this.getSourceMapper();
        if (mapper != null && (classFile = this.getClassFile()) != null) {
            classFile.getBuffer();
            return mapper.getSourceRange(this);
        }
        return super.getSourceRange();
    }

    @Override
    public IClassFile getClassFile() {
        return this.getParent().getClassFile();
    }

    @Override
    protected void toStringName(StringBuilder buffer) {
        buffer.append('@');
        buffer.append(this.getElementName());
    }
}

