/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.editor;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.gef.editparts.GridLayer;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.AlignmentAction;
import org.eclipse.gef.ui.actions.DirectEditAction;
import org.eclipse.gef.ui.actions.MatchHeightAction;
import org.eclipse.gef.ui.actions.MatchWidthAction;
import org.eclipse.gef.ui.actions.ToggleGridAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.graphiti.DiagramScrollingBehavior;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IPrintFeature;
import org.eclipse.graphiti.features.ISaveImageFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.internal.command.AddFeatureCommandWithContext;
import org.eclipse.graphiti.internal.command.GenericFeatureCommandWithContext;
import org.eclipse.graphiti.internal.command.ICommand;
import org.eclipse.graphiti.internal.services.GraphitiInternal;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.platform.IDiagramBehavior;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.ui.editor.DefaultMarkerBehavior;
import org.eclipse.graphiti.ui.editor.DefaultPaletteBehavior;
import org.eclipse.graphiti.ui.editor.DefaultPersistencyBehavior;
import org.eclipse.graphiti.ui.editor.DefaultRefreshBehavior;
import org.eclipse.graphiti.ui.editor.DefaultUpdateBehavior;
import org.eclipse.graphiti.ui.editor.DiagramEditorContextMenuProvider;
import org.eclipse.graphiti.ui.editor.IDiagramBehaviorUI;
import org.eclipse.graphiti.ui.editor.IDiagramContainerUI;
import org.eclipse.graphiti.ui.editor.IDiagramEditorInput;
import org.eclipse.graphiti.ui.internal.action.CopyAction;
import org.eclipse.graphiti.ui.internal.action.DeleteAction;
import org.eclipse.graphiti.ui.internal.action.FeatureExecutionHandler;
import org.eclipse.graphiti.ui.internal.action.PasteAction;
import org.eclipse.graphiti.ui.internal.action.PrintGraphicalViewerAction;
import org.eclipse.graphiti.ui.internal.action.RemoveAction;
import org.eclipse.graphiti.ui.internal.action.SaveImageAction;
import org.eclipse.graphiti.ui.internal.action.ToggleContextButtonPadAction;
import org.eclipse.graphiti.ui.internal.action.UpdateAction;
import org.eclipse.graphiti.ui.internal.command.GefCommandWrapper;
import org.eclipse.graphiti.ui.internal.config.ConfigurationProvider;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProviderInternal;
import org.eclipse.graphiti.ui.internal.contextbuttons.ContextButtonManagerForPad;
import org.eclipse.graphiti.ui.internal.contextbuttons.IContextButtonManager;
import org.eclipse.graphiti.ui.internal.dnd.GFTemplateTransferDropTargetListener;
import org.eclipse.graphiti.ui.internal.dnd.ObjectsTransferDropTargetListener;
import org.eclipse.graphiti.ui.internal.editor.DiagramChangeListener;
import org.eclipse.graphiti.ui.internal.editor.DomainModelChangeListener;
import org.eclipse.graphiti.ui.internal.editor.GFCommandStack;
import org.eclipse.graphiti.ui.internal.editor.GFFigureCanvas;
import org.eclipse.graphiti.ui.internal.editor.GFScrollingGraphicalViewer;
import org.eclipse.graphiti.ui.internal.editor.GraphitiScrollingGraphicalViewer;
import org.eclipse.graphiti.ui.internal.util.gef.ScalableRootEditPartAnimated;
import org.eclipse.graphiti.ui.platform.IConfigurationProvider;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class DiagramBehavior
implements IDiagramBehaviorUI {
    private IDiagramContainerUI diagramContainer;
    private DefaultUpdateBehavior updateBehavior;
    private DefaultPaletteBehavior paletteBehaviour;
    private DefaultPersistencyBehavior persistencyBehavior;
    private DefaultMarkerBehavior markerBehavior;
    private DefaultRefreshBehavior refreshBehavior;
    private PictogramElement[] pictogramElementsForSelection;
    private IConfigurationProvider configurationProvider;
    private Point mouseLocation;
    private KeyHandler keyHandler;
    private DiagramScrollingBehavior diagramScrollingBehavior;
    private boolean directEditingActive = false;
    private CommandStackEventListener gefCommandStackListener;
    private DiagramChangeListener diagramChangeListener;
    private DomainModelChangeListener domainModelListener;
    private IDiagramEditorInput diagramEditorInput;
    private String editorInitializationError = null;
    private IWorkbenchPart parentPart;
    private ContextMenuProvider contextMenuProvider = null;
    private ResourceManager resourceManager = null;

    public DiagramBehavior(IDiagramContainerUI diagramContainer) {
        this.setDiagramContainer(diagramContainer);
    }

    protected void setDiagramContainer(IDiagramContainerUI diagramContainer) {
        if (this.diagramContainer != null) {
            throw new IllegalStateException("diagramContainer must not be changed once it has been set");
        }
        this.diagramContainer = diagramContainer;
    }

    public IDiagramContainerUI getDiagramContainer() {
        return this.diagramContainer;
    }

    protected DefaultMarkerBehavior createMarkerBehavior() {
        return new DefaultMarkerBehavior(this);
    }

    protected DefaultMarkerBehavior getMarkerBehavior() {
        return this.markerBehavior;
    }

    protected DefaultUpdateBehavior createUpdateBehavior() {
        return new DefaultUpdateBehavior(this);
    }

    public DefaultUpdateBehavior getUpdateBehavior() {
        return this.updateBehavior;
    }

    protected DefaultPaletteBehavior createPaletteBehaviour() {
        return new DefaultPaletteBehavior(this);
    }

    protected DefaultPaletteBehavior getPaletteBehavior() {
        return this.paletteBehaviour;
    }

    protected DefaultPersistencyBehavior createPersistencyBehavior() {
        return new DefaultPersistencyBehavior(this);
    }

    protected DefaultPersistencyBehavior getPersistencyBehavior() {
        return this.persistencyBehavior;
    }

    protected DefaultRefreshBehavior createRefreshBehavior() {
        return new DefaultRefreshBehavior(this);
    }

    public DefaultRefreshBehavior getRefreshBehavior() {
        return this.refreshBehavior;
    }

    protected void initDefaultBehaviors() {
        this.markerBehavior = this.createMarkerBehavior();
        this.updateBehavior = this.createUpdateBehavior();
        this.paletteBehaviour = this.createPaletteBehaviour();
        this.persistencyBehavior = this.createPersistencyBehavior();
        this.refreshBehavior = this.createRefreshBehavior();
    }

    protected void setInput(IDiagramEditorInput input) {
        if (input == null) {
            throw new IllegalArgumentException("The IEditorInput must not be null");
        }
        this.setDiagramEditorInput(input);
        Diagram diagram = this.getPersistencyBehavior().loadDiagram(this.getInput().getUri());
        if (diagram == null) {
            this.setEditorInitializationError("No Diagram found for URI '" + this.getInput().getUri().toString());
            return;
        }
        IDiagramTypeProvider diagramTypeProvider = this.initDiagramTypeProvider(diagram);
        this.initConfigurationProvider(diagramTypeProvider);
        this.getRefreshBehavior().handleAutoUpdateAtStartup();
        this.getDiagramContainer().refreshTitle();
        this.registerBusinessObjectsListener();
        this.registerDiagramResourceSetListener();
    }

    protected IDiagramTypeProvider initDiagramTypeProvider(Diagram diagram) {
        String providerId = this.getDiagramTypeProviderId(diagram);
        IDiagramTypeProvider diagramTypeProvider = GraphitiUi.getExtensionManager().createDiagramTypeProvider(providerId);
        if (diagramTypeProvider == null) {
            this.setEditorInitializationError("Could not find diagram type provider for " + diagram.getDiagramTypeId());
            return null;
        }
        diagramTypeProvider.init(diagram, (IDiagramBehavior)this);
        return diagramTypeProvider;
    }

    protected String getDiagramTypeProviderId(Diagram diagram) {
        String providerId = this.getInput().getProviderId();
        if (providerId == null) {
            providerId = GraphitiUi.getExtensionManager().getDiagramTypeProviderId(diagram.getDiagramTypeId());
            this.getInput().setProviderId(providerId);
        }
        if (providerId == null) {
            String message = "DiagramEditorInput does not convey a Provider ID '" + String.valueOf(this.getInput()) + ". See the error log for details.";
            this.setEditorInitializationError(message);
            Assert.isNotNull((Object)providerId, (String)message);
        }
        return providerId;
    }

    protected void addGefListeners() {
        this.getDiagramTypeProvider().postInit();
        this.gefCommandStackListener = new CommandStackEventListener(){

            public void stackChanged(CommandStackEvent event) {
                IDiagramContainerUI diagramContainer;
                if (Display.getCurrent() != null && (diagramContainer = DiagramBehavior.this.getDiagramContainer()) != null) {
                    diagramContainer.updateDirtyState();
                    diagramContainer.commandStackChanged((EventObject)event);
                }
            }
        };
        this.getEditDomain().getCommandStack().addCommandStackEventListener(this.gefCommandStackListener);
    }

    protected void createGraphicalViewer(Composite parent) {
        GraphitiScrollingGraphicalViewer viewer;
        if (this.getDiagramScrollingBehavior() == DiagramScrollingBehavior.SCROLLBARS_ALWAYS_VISIBLE) {
            viewer = new GFScrollingGraphicalViewer(this);
            ((GFScrollingGraphicalViewer)viewer).createGFControl(parent);
        } else {
            viewer = new GraphitiScrollingGraphicalViewer(this);
            viewer.createControl(parent);
        }
        IDiagramContainerUI diagramContainer = this.getDiagramContainer();
        diagramContainer.setGraphicalViewer((GraphicalViewer)viewer);
        diagramContainer.configureGraphicalViewer();
        diagramContainer.hookGraphicalViewer();
        diagramContainer.initializeGraphicalViewer();
    }

    protected void configureGraphicalViewer() {
        GFFigureCanvas figureCanvas;
        ScrollingGraphicalViewer viewer = (ScrollingGraphicalViewer)this.getDiagramContainer().getGraphicalViewer();
        ScalableRootEditPartAnimated rootEditPart = new ScalableRootEditPartAnimated(viewer, this.getConfigurationProvider()){

            protected GridLayer createGridLayer() {
                return new org.eclipse.graphiti.ui.internal.util.draw2d.GridLayer((IConfigurationProviderInternal)DiagramBehavior.this.getConfigurationProvider());
            }
        };
        viewer.setRootEditPart((RootEditPart)rootEditPart);
        ZoomManager zoomManager = rootEditPart.getZoomManager();
        ArrayList<String> zoomLevels = new ArrayList<String>(3);
        zoomLevels.add(ZoomManager.FIT_ALL);
        zoomLevels.add(ZoomManager.FIT_WIDTH);
        zoomLevels.add(ZoomManager.FIT_HEIGHT);
        zoomManager.setZoomLevelContributions(zoomLevels);
        IToolBehaviorProvider toolBehaviorProvider = this.getConfigurationProvider().getDiagramTypeProvider().getCurrentToolBehaviorProvider();
        zoomManager.setZoomLevels(toolBehaviorProvider.getZoomLevels());
        this.initActionRegistry(zoomManager);
        viewer.setKeyHandler(new GraphicalViewerKeyHandler((GraphicalViewer)viewer).setParent(this.getCommonKeyHandler()));
        Diagram diagram = this.getConfigurationProvider().getDiagram();
        boolean snapToGrid = diagram.isSnapToGrid();
        int horizontalGridUnit = diagram.getGridUnit();
        int verticalGridUnit = diagram.getVerticalGridUnit();
        if (verticalGridUnit == -1) {
            verticalGridUnit = horizontalGridUnit;
        }
        boolean gridVisisble = horizontalGridUnit > 0 && verticalGridUnit > 0;
        viewer.setProperty("SnapToGrid.isVisible", (Object)new Boolean(gridVisisble));
        viewer.setProperty("SnapToGrid.isEnabled", (Object)new Boolean(snapToGrid));
        viewer.setProperty("SnapToGrid.GridSpacing", (Object)new Dimension(horizontalGridUnit, verticalGridUnit));
        viewer.setProperty("SnapToGeometry.isEnabled", (Object)toolBehaviorProvider.isShowGuides());
        IConfigurationProviderInternal configurationProvider = (IConfigurationProviderInternal)this.getConfigurationProvider();
        configurationProvider.setContextButtonManager(new ContextButtonManagerForPad(this, configurationProvider.getResourceRegistry()));
        if (this.getDiagramScrollingBehavior() == DiagramScrollingBehavior.SCROLLBARS_ALWAYS_VISIBLE && (figureCanvas = this.getGFFigureCanvas()) != null) {
            figureCanvas.setScrollBarVisibility(FigureCanvas.ALWAYS);
        }
    }

    protected void initializeGraphicalViewer() {
        IPrintFeature pf;
        IFeatureProvider featureProvider = this.getConfigurationProvider().getDiagramTypeProvider().getFeatureProvider();
        if (featureProvider != null && (pf = featureProvider.getPrintFeature()) != null && this.parentPart != null) {
            this.registerAction((IAction)new PrintGraphicalViewerAction(this, this.getConfigurationProvider()));
        }
        this.contextMenuProvider = this.createContextMenuProvider();
        GraphicalViewer graphicalViewer = this.getDiagramContainer().getGraphicalViewer();
        if (this.contextMenuProvider != null) {
            graphicalViewer.setContextMenu((MenuManager)this.contextMenuProvider);
            if (this.shouldRegisterContextMenu() && this.parentPart != null) {
                this.parentPart.getSite().registerContextMenu((MenuManager)this.contextMenuProvider, (ISelectionProvider)graphicalViewer);
            }
        }
        graphicalViewer.setEditPartFactory((EditPartFactory)((IConfigurationProviderInternal)this.getConfigurationProvider()).getEditPartFactory());
        graphicalViewer.setContents((Object)this.getConfigurationProvider().getDiagram());
        this.getPaletteBehavior().initializeViewer();
        graphicalViewer.getControl().addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                DiagramBehavior.this.setMouseLocation(e.x, e.y);
            }
        });
        List<TransferDropTargetListener> objectDropTargetListeners = this.createBusinessObjectDropTargetListeners();
        for (TransferDropTargetListener dropTargetListener : objectDropTargetListeners) {
            graphicalViewer.addDropTargetListener(dropTargetListener);
        }
        TransferDropTargetListener paletteDropTargetListener = this.createPaletteDropTargetListener();
        if (paletteDropTargetListener != null) {
            graphicalViewer.addDropTargetListener(paletteDropTargetListener);
        }
    }

    protected TransferDropTargetListener createPaletteDropTargetListener() {
        return new GFTemplateTransferDropTargetListener((EditPartViewer)this.getDiagramContainer().getGraphicalViewer(), this);
    }

    protected List<TransferDropTargetListener> createBusinessObjectDropTargetListeners() {
        ArrayList<TransferDropTargetListener> result = new ArrayList<TransferDropTargetListener>(1);
        result.add((TransferDropTargetListener)new ObjectsTransferDropTargetListener((EditPartViewer)this.getDiagramContainer().getGraphicalViewer()));
        return result;
    }

    protected String getEditorInitializationError() {
        return this.editorInitializationError;
    }

    protected void setEditorInitializationError(String editorInitializationError) {
        this.editorInitializationError = editorInitializationError;
    }

    protected void createErrorPartControl(Composite parent) {
        Color separatorColor;
        Color foregroundColor;
        Color backgroundColor;
        Display display = parent.getDisplay();
        if (display.getHighContrast()) {
            backgroundColor = display.getSystemColor(22);
            separatorColor = foregroundColor = display.getSystemColor(21);
        } else {
            backgroundColor = display.getSystemColor(1);
            foregroundColor = display.getSystemColor(10);
            separatorColor = new Color((Device)display, 152, 170, 203);
        }
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 768);
        scrolledComposite.setAlwaysShowScrollBars(false);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (separatorColor != foregroundColor) {
                    separatorColor.dispose();
                }
            }
        });
        Composite composite = new Composite((Composite)scrolledComposite, 0);
        composite.setBackground(backgroundColor);
        composite.setLayout((Layout)new GridLayout());
        Composite separator = new Composite(composite, 524288);
        separator.setBackground(separatorColor);
        GridData data = new GridData(768);
        data.heightHint = 2;
        data.verticalIndent = 50;
        separator.setLayoutData((Object)data);
        StyledText widget = new StyledText(composite, 10);
        widget.setLayoutData((Object)new GridData(768));
        widget.setText(this.getEditorInitializationError());
        widget.setBackground(backgroundColor);
        widget.setForeground(foregroundColor);
        widget.setCaret(null);
        scrolledComposite.setContent((Control)composite);
        scrolledComposite.setMinSize(composite.computeSize(-1, -1));
    }

    protected boolean isDirty() {
        return this.getPersistencyBehavior().isDirty();
    }

    protected final PaletteViewerProvider createPaletteViewerProvider() {
        if (this.getEditorInitializationError() != null) {
            return null;
        }
        return this.paletteBehaviour.createPaletteViewerProvider();
    }

    protected final FlyoutPaletteComposite.FlyoutPreferences getPalettePreferences() {
        return this.getPaletteBehavior().getPalettePreferences();
    }

    protected final PaletteRoot getPaletteRoot() {
        return this.getPaletteBehavior().getPaletteRoot();
    }

    public void refresh() {
        this.getRefreshBehavior().refresh();
    }

    public void refreshRenderingDecorators(PictogramElement pe) {
        this.getRefreshBehavior().refreshRenderingDecorators(pe);
    }

    public void refreshPalette() {
        this.getPaletteBehavior().refreshPalette();
    }

    public void refreshContent() {
        Diagram currentDiagram = this.getDiagramTypeProvider().getDiagram();
        if (GraphitiInternal.getEmfService().isObjectAlive((EObject)currentDiagram)) {
            this.refresh();
        } else {
            IDiagramEditorInput diagramEditorInput = this.getDiagramContainer().getDiagramEditorInput();
            Diagram diagram = this.getPersistencyBehavior().loadDiagram(diagramEditorInput.getUri());
            IDiagramTypeProvider diagramTypeProvider = this.getConfigurationProvider().getDiagramTypeProvider();
            diagramTypeProvider.resourceReloaded(diagram);
            this.getRefreshBehavior().initRefresh();
            this.setPictogramElementsForSelection(null);
            this.getDiagramContainer().getGraphicalViewer().setContents((Object)diagram);
            this.getRefreshBehavior().handleAutoUpdateAtReset();
        }
    }

    protected void selectPictogramElements(PictogramElement[] pictogramElements) {
        ArrayList<EditPart> editParts = new ArrayList<EditPart>();
        Map editPartRegistry = this.getDiagramContainer().getGraphicalViewer().getEditPartRegistry();
        if (editPartRegistry != null) {
            int i = 0;
            while (i < pictogramElements.length) {
                Object obj;
                PictogramElement pe = pictogramElements[i];
                if (pe != null && pe.isVisible() && (obj = editPartRegistry.get(pe)) instanceof EditPart && ((EditPart)obj).isSelectable()) {
                    editParts.add((EditPart)obj);
                }
                ++i;
            }
            if (this.parentPart != null) {
                this.parentPart.getSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection(editParts));
            }
            if (editParts.size() > 0) {
                final EditPart editpart = (EditPart)editParts.get(0);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        GraphicalViewer graphicalViewer = DiagramBehavior.this.getDiagramContainer().getGraphicalViewer();
                        if (graphicalViewer.getControl() != null) {
                            graphicalViewer.reveal(editpart);
                        }
                    }
                });
            }
        }
    }

    public PictogramElement[] getSelectedPictogramElements() {
        ISelection s;
        PictogramElement[] pe = new PictogramElement[]{};
        Object selectionProvider = null;
        selectionProvider = this.parentPart == null ? this.getDiagramContainer().getGraphicalViewer() : this.parentPart.getSite().getSelectionProvider();
        if (selectionProvider != null && (s = selectionProvider.getSelection()) instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)s;
            ArrayList<PictogramElement> list = new ArrayList<PictogramElement>();
            for (Object o : sel) {
                EditPart editPart;
                if (!(o instanceof EditPart) || !((editPart = (EditPart)o).getModel() instanceof PictogramElement)) continue;
                list.add((PictogramElement)editPart.getModel());
            }
            pe = list.toArray(new PictogramElement[0]);
        }
        return pe;
    }

    public void setPictogramElementForSelection(PictogramElement pictogramElement) {
        this.pictogramElementsForSelection = pictogramElement == null ? null : new PictogramElement[]{pictogramElement};
    }

    protected void setPictogramElementsForSelection(PictogramElement[] pictogramElements) {
        this.pictogramElementsForSelection = pictogramElements;
    }

    public void selectBufferedPictogramElements() {
        if (this.getPictogramElementsForSelection() != null) {
            this.selectPictogramElements(this.getPictogramElementsForSelection());
            this.setPictogramElementsForSelection(null);
        }
    }

    protected PictogramElement[] getPictogramElementsForSelection() {
        return this.pictogramElementsForSelection;
    }

    public TransactionalEditingDomain getEditingDomain() {
        return this.getUpdateBehavior().getEditingDomain();
    }

    public ResourceSet getResourceSet() {
        ResourceSet ret = null;
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        if (editingDomain != null) {
            ret = editingDomain.getResourceSet();
        }
        return ret;
    }

    public IDiagramTypeProvider getDiagramTypeProvider() {
        IConfigurationProvider cfgProvider = this.getConfigurationProvider();
        if (cfgProvider != null) {
            return cfgProvider.getDiagramTypeProvider();
        }
        return null;
    }

    public Object executeFeature(IFeature feature, IContext context) {
        PictogramElement returnValue = null;
        DefaultEditDomain domain = this.getDiagramContainer().getEditDomain();
        Assert.isNotNull((Object)domain);
        CommandStack commandStack = domain.getCommandStack();
        GenericFeatureCommandWithContext featureCommand = null;
        if (feature instanceof IAddFeature) {
            Assert.isTrue((boolean)(context instanceof IAddContext));
            featureCommand = new AddFeatureCommandWithContext(feature, context);
        } else {
            featureCommand = new GenericFeatureCommandWithContext(feature, context);
        }
        GefCommandWrapper commandWrapper = new GefCommandWrapper((ICommand)featureCommand, this.getEditingDomain());
        commandStack.execute((org.eclipse.gef.commands.Command)commandWrapper);
        if (featureCommand instanceof AddFeatureCommandWithContext) {
            PictogramElement addedPictogramElement = ((AddFeatureCommandWithContext)featureCommand).getAddedPictogramElements();
            if (addedPictogramElement != null) {
                this.setPictogramElementForSelection(addedPictogramElement);
            }
            returnValue = addedPictogramElement;
        }
        return returnValue;
    }

    public void disableAdapters() {
        this.markerBehavior.disableProblemIndicationUpdate();
        this.updateBehavior.setAdapterActive(false);
    }

    public void enableAdapters() {
        this.markerBehavior.enableProblemIndicationUpdate();
        this.updateBehavior.setAdapterActive(true);
    }

    public boolean isAlive() {
        IConfigurationProvider cp = this.getConfigurationProvider();
        if (cp != null) {
            TransactionalEditingDomain editingDomain = this.getEditingDomain();
            Diagram diagram = cp.getDiagram();
            if (editingDomain != null && GraphitiInternal.getEmfService().isObjectAlive((EObject)diagram)) {
                return true;
            }
        }
        return false;
    }

    protected void editingDomainInitialized() {
        this.markerBehavior.initialize();
    }

    public Object getAdapter(Class type) {
        Object ret;
        IToolBehaviorProvider toolBehaviorProvider;
        IDiagramTypeProvider diagramTypeProvider;
        IConfigurationProvider cfgProvider = this.getConfigurationProvider();
        if (cfgProvider != null && (diagramTypeProvider = cfgProvider.getDiagramTypeProvider()) != null && (toolBehaviorProvider = diagramTypeProvider.getCurrentToolBehaviorProvider()) != null && (ret = toolBehaviorProvider.getAdapter(type)) != null) {
            return ret;
        }
        IDiagramContainerUI diagramContainer = this.getDiagramContainer();
        GraphicalViewer viewer = diagramContainer.getGraphicalViewer();
        if (type == ZoomManager.class && viewer != null) {
            return viewer.getProperty(ZoomManager.class.toString());
        }
        if (type == IPropertySheetPage.class) {
            ITabbedPropertySheetPageContributor contributor;
            if (cfgProvider != null && diagramContainer instanceof ITabbedPropertySheetPageContributor && (contributor = (ITabbedPropertySheetPageContributor)diagramContainer).getContributorId() != null) {
                return new TabbedPropertySheetPage(contributor);
            }
            return null;
        }
        if (type == Diagram.class) {
            IDiagramTypeProvider diagramTypeProvider2 = this.getDiagramTypeProvider();
            if (diagramTypeProvider2 != null) {
                return diagramTypeProvider2.getDiagram();
            }
            return null;
        }
        if (type == KeyHandler.class) {
            return this.getCommonKeyHandler();
        }
        if (type == IContextButtonManager.class) {
            return ((IConfigurationProviderInternal)this.getConfigurationProvider()).getContextButtonManager();
        }
        return null;
    }

    public IConfigurationProvider getConfigurationProvider() {
        return this.configurationProvider;
    }

    public EditPart getContentEditPart() {
        if (this.getDiagramContainer().getGraphicalViewer() != null) {
            return this.getDiagramContainer().getGraphicalViewer().getContents();
        }
        return null;
    }

    @Override
    public GraphicalEditPart getEditPartForPictogramElement(PictogramElement pe) {
        Object obj;
        Map editPartRegistry = this.getDiagramContainer().getGraphicalViewer().getEditPartRegistry();
        if (editPartRegistry != null && (obj = editPartRegistry.get(pe)) instanceof GraphicalEditPart) {
            GraphicalEditPart ep = (GraphicalEditPart)obj;
            return ep;
        }
        return null;
    }

    public Point getMouseLocation() {
        if (this.mouseLocation == null) {
            this.mouseLocation = new Point();
        }
        return this.mouseLocation;
    }

    @Override
    public Point calculateRealMouseLocation(Point nativeLocation) {
        Point ret = new Point(nativeLocation);
        Point viewLocation = this.getDiagramScrollingBehavior() == DiagramScrollingBehavior.SCROLLBARS_ALWAYS_VISIBLE ? this.getGFFigureCanvas().getViewport().getViewLocation() : this.getFigureCanvas().getViewport().getViewLocation();
        ret.x += viewLocation.x;
        ret.y += viewLocation.y;
        ZoomManager zoomManager = (ZoomManager)this.getDiagramContainer().getGraphicalViewer().getProperty(ZoomManager.class.toString());
        ret = ret.getScaled(1.0 / zoomManager.getZoom());
        return ret;
    }

    public boolean isDirectEditingActive() {
        return this.directEditingActive;
    }

    public void setDirectEditingActive(boolean directEditingActive) {
        this.directEditingActive = directEditingActive;
        ((IConfigurationProviderInternal)this.getConfigurationProvider()).getContextButtonManager().hideContextButtonsInstantly();
    }

    public double getZoomLevel() {
        ZoomManager zoomManager = (ZoomManager)this.getAdapter(ZoomManager.class);
        if (zoomManager == null) {
            return 1.0;
        }
        return Math.max(0.05, zoomManager.getZoom());
    }

    @Override
    public IFigure getFigureForPictogramElement(PictogramElement pe) {
        GraphicalEditPart ep = this.getEditPartForPictogramElement(pe);
        if (ep != null) {
            return ep.getFigure();
        }
        return null;
    }

    protected void initConfigurationProvider(IDiagramTypeProvider diagramTypeProvider) {
        this.configurationProvider = this.createConfigurationProvider(diagramTypeProvider);
        this.configurationProvider.setWorkbenchPart(this.parentPart);
        if (this.getDiagramContainer().getGraphicalViewer() != null) {
            this.initializeGraphicalViewer();
        }
        if (this.getDiagramContainer() instanceof IEditorPart) {
            DefaultEditDomain editDomain = new DefaultEditDomain((IEditorPart)this.getDiagramContainer());
            this.getDiagramContainer().setEditDomain(editDomain);
        }
        GFCommandStack commandStack = new GFCommandStack(this.configurationProvider, this.getEditingDomain());
        this.getEditDomain().setCommandStack((CommandStack)commandStack);
    }

    protected IConfigurationProvider createConfigurationProvider(IDiagramTypeProvider diagramTypeProvider) {
        return new ConfigurationProvider(this, diagramTypeProvider);
    }

    private void setMouseLocation(int x, int y) {
        this.getMouseLocation().setLocation(x, y);
    }

    protected ContextMenuProvider createContextMenuProvider() {
        return new DiagramEditorContextMenuProvider((EditPartViewer)this.getDiagramContainer().getGraphicalViewer(), this.getDiagramContainer().getActionRegistry(), this.getConfigurationProvider());
    }

    protected boolean shouldRegisterContextMenu() {
        return true;
    }

    protected void registerAction(IAction action) {
        if (action == null || this.parentPart == null) {
            return;
        }
        IDiagramContainerUI diagramContainer = this.getDiagramContainer();
        diagramContainer.getActionRegistry().registerAction(action);
        if (action.getActionDefinitionId() != null) {
            IHandlerService hs = (IHandlerService)this.parentPart.getSite().getService(IHandlerService.class);
            hs.activateHandler(action.getActionDefinitionId(), (IHandler)new ActionHandler(action));
        }
        List selectionActions = diagramContainer.getSelectionActions();
        selectionActions.add(action.getId());
    }

    protected void initActionRegistry(ZoomManager zoomManager) {
        ISaveImageFeature sf;
        if (this.parentPart == null) {
            return;
        }
        IDiagramContainerUI diagramContainer = this.getDiagramContainer();
        ActionRegistry actionRegistry = diagramContainer.getActionRegistry();
        List selectionActions = diagramContainer.getSelectionActions();
        Object action = new UpdateAction(this.parentPart, this.getConfigurationProvider());
        actionRegistry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new RemoveAction(this.parentPart, this.getConfigurationProvider());
        actionRegistry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new DeleteAction(this.parentPart, this.getConfigurationProvider());
        actionRegistry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new CopyAction(this.parentPart, this.getConfigurationProvider());
        actionRegistry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new PasteAction(this.parentPart, this.getConfigurationProvider());
        actionRegistry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        IFeatureProvider fp = this.getConfigurationProvider().getDiagramTypeProvider().getFeatureProvider();
        if (fp != null && (sf = fp.getSaveImageFeature()) != null) {
            action = new SaveImageAction(this, this.getConfigurationProvider());
            actionRegistry.registerAction((IAction)action);
            selectionActions.add(action.getId());
        }
        this.registerAction((IAction)new ZoomInAction(zoomManager));
        this.registerAction((IAction)new ZoomOutAction(zoomManager));
        this.registerAction((IAction)new DirectEditAction(this.parentPart));
        this.registerAction((IAction)new AlignmentAction(this.parentPart, 1));
        this.registerAction((IAction)new AlignmentAction(this.parentPart, 4));
        this.registerAction((IAction)new AlignmentAction(this.parentPart, 8));
        this.registerAction((IAction)new AlignmentAction(this.parentPart, 32));
        this.registerAction((IAction)new AlignmentAction(this.parentPart, 2));
        this.registerAction((IAction)new AlignmentAction(this.parentPart, 16));
        this.registerAction((IAction)new MatchWidthAction(this.parentPart));
        this.registerAction((IAction)new MatchHeightAction(this.parentPart));
        ToggleGridAction showGrid = new ToggleGridAction(diagramContainer.getGraphicalViewer());
        diagramContainer.getActionRegistry().registerAction((IAction)showGrid);
        ToggleContextButtonPadAction toggleContextButtonPad = new ToggleContextButtonPadAction(this);
        toggleContextButtonPad.setChecked(false);
        actionRegistry.registerAction((IAction)toggleContextButtonPad);
        IHandlerService hs = (IHandlerService)this.parentPart.getSite().getService(IHandlerService.class);
        hs.activateHandler("org.eclipse.graphiti.ui.featureExecutionCommand", (IHandler)new FeatureExecutionHandler(this.getConfigurationProvider()));
    }

    protected KeyHandler getCommonKeyHandler() {
        if (this.keyHandler == null) {
            this.keyHandler = new KeyHandler();
            IDiagramContainerUI diagramContainer = this.getDiagramContainer();
            this.keyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), diagramContainer.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
            this.keyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)131072), diagramContainer.getActionRegistry().getAction((Object)"predefined remove action"));
            this.keyHandler.put(KeyStroke.getPressed((int)0x100000B, (int)0), diagramContainer.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
            this.keyHandler.put(KeyStroke.getPressed((char)'c', (int)262144), diagramContainer.getActionRegistry().getAction((Object)ActionFactory.COPY.getId()));
            this.keyHandler.put(KeyStroke.getPressed((char)'v', (int)262144), diagramContainer.getActionRegistry().getAction((Object)ActionFactory.PASTE.getId()));
        }
        return this.keyHandler;
    }

    @Deprecated
    private DiagramScrollingBehavior getDiagramScrollingBehavior() {
        if (this.diagramScrollingBehavior == null) {
            IToolBehaviorProvider tbp = this.getConfigurationProvider().getDiagramTypeProvider().getCurrentToolBehaviorProvider();
            this.diagramScrollingBehavior = tbp.getDiagramScrollingBehavior();
        }
        return this.diagramScrollingBehavior;
    }

    private FigureCanvas getFigureCanvas() {
        Control control;
        GraphicalViewer viewer = this.getDiagramContainer().getGraphicalViewer();
        if (viewer != null && (control = viewer.getControl()) instanceof FigureCanvas) {
            return (FigureCanvas)control;
        }
        return null;
    }

    private GFFigureCanvas getGFFigureCanvas() {
        Control control;
        GraphicalViewer viewer = this.getDiagramContainer().getGraphicalViewer();
        if (viewer != null && (control = viewer.getControl()) instanceof GFFigureCanvas) {
            return (GFFigureCanvas)control;
        }
        return null;
    }

    protected void unregisterDiagramResourceSetListener() {
        if (this.diagramChangeListener != null) {
            this.diagramChangeListener.stopListening();
            TransactionalEditingDomain editingDomain = this.getEditingDomain();
            if (editingDomain != null) {
                editingDomain.removeResourceSetListener((ResourceSetListener)this.diagramChangeListener);
            }
        }
    }

    protected void unregisterBusinessObjectsListener() {
        if (this.domainModelListener != null) {
            TransactionalEditingDomain eDomain = this.getEditingDomain();
            eDomain.removeResourceSetListener((ResourceSetListener)this.domainModelListener);
        }
    }

    protected void registerDiagramResourceSetListener() {
        this.diagramChangeListener = new DiagramChangeListener(this);
        TransactionalEditingDomain eDomain = this.getEditingDomain();
        eDomain.addResourceSetListener((ResourceSetListener)this.diagramChangeListener);
    }

    protected void registerBusinessObjectsListener() {
        this.domainModelListener = new DomainModelChangeListener(this);
        TransactionalEditingDomain eDomain = this.getEditingDomain();
        eDomain.addResourceSetListener((ResourceSetListener)this.domainModelListener);
    }

    protected IDiagramEditorInput getInput() {
        return this.diagramEditorInput;
    }

    protected void setDiagramEditorInput(IDiagramEditorInput diagramEditorInput) {
        this.diagramEditorInput = diagramEditorInput;
    }

    protected void disposeBeforeGefDispose() {
        this.unregisterDiagramResourceSetListener();
        this.unregisterBusinessObjectsListener();
        if (this.getConfigurationProvider() != null) {
            this.getConfigurationProvider().dispose();
        }
        if (this.paletteBehaviour != null) {
            this.paletteBehaviour.dispose();
        }
        this.markerBehavior.dispose();
        IDiagramContainerUI diagramContainer = this.getDiagramContainer();
        if (diagramContainer instanceof ISelectionListener && diagramContainer.getSite() != null && diagramContainer.getSite().getPage() != null) {
            diagramContainer.getSite().getPage().removeSelectionListener((ISelectionListener)diagramContainer);
        }
        if (this.getEditDomain() != null && this.getEditDomain().getCommandStack() != null) {
            this.getEditDomain().getCommandStack().removeCommandStackEventListener(this.gefCommandStackListener);
            this.getEditDomain().getCommandStack().dispose();
        }
        DefaultUpdateBehavior behavior = this.getUpdateBehavior();
        behavior.dispose();
        if (this.contextMenuProvider != null) {
            this.contextMenuProvider.dispose();
            this.contextMenuProvider = null;
        }
    }

    protected void disposeAfterGefDispose() {
        if (this.getEditDomain() != null) {
            this.getEditDomain().setCommandStack(null);
        }
        if (this.resourceManager != null) {
            this.resourceManager.dispose();
        }
    }

    protected void migrateDiagramModelIfNecessary() {
        final Diagram diagram = this.getDiagramTypeProvider().getDiagram();
        if (Graphiti.getMigrationService().shouldMigrate080To090(diagram)) {
            this.getEditingDomain().getCommandStack().execute((Command)new RecordingCommand(this.getEditingDomain()){

                protected void doExecute() {
                    Graphiti.getMigrationService().migrate080To090(diagram);
                }
            });
        }
    }

    @Override
    public DefaultEditDomain getEditDomain() {
        return this.getDiagramContainer().getEditDomain();
    }

    protected void setParentPart(IWorkbenchPart parentPart) {
        this.parentPart = parentPart;
    }

    protected IWorkbenchPart getParentPart() {
        return this.parentPart;
    }

    protected ResourceManager createResourceManager() {
        return new LocalResourceManager(JFaceResources.getResources());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceManager getResourceManager() {
        DiagramBehavior diagramBehavior = this;
        synchronized (diagramBehavior) {
            if (this.resourceManager == null) {
                this.resourceManager = this.createResourceManager();
            }
        }
        return this.resourceManager;
    }
}

