/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.wsdl11;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.IWSDL11ValidationInfo;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.IWSDL11Validator;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.WSDL11ValidatorDelegate;

public class ValidatorRegistry {
    protected static ValidatorRegistry verInstance;
    protected Map validatorReg = new Hashtable();

    protected ValidatorRegistry() {
    }

    public static ValidatorRegistry getInstance() {
        if (verInstance == null) {
            verInstance = new ValidatorRegistry();
        }
        return verInstance;
    }

    public void registerValidator(String namespace, WSDL11ValidatorDelegate valDelegate) {
        if (namespace == null) {
            namespace = "";
        }
        if (!this.validatorReg.containsKey(namespace)) {
            this.validatorReg.put(namespace, new WSDL11ValidatorDelegateContainer());
        }
        ((WSDL11ValidatorDelegateContainer)this.validatorReg.get(namespace)).addValidator(valDelegate);
    }

    public IWSDL11Validator queryValidatorRegistry(String namespace) {
        if (namespace == null) {
            namespace = "";
        }
        return (IWSDL11Validator)this.validatorReg.get(namespace);
    }

    public boolean hasRegisteredValidator(String namespace) {
        return this.queryValidatorRegistry(namespace) != null;
    }

    public class WSDL11ValidatorDelegateContainer
    implements IWSDL11Validator {
        private List validatorDelegates = new ArrayList();

        public void addValidator(WSDL11ValidatorDelegate delegate) {
            this.validatorDelegates.add(delegate);
        }

        public void setResourceBundle(ResourceBundle rb) {
        }

        @Override
        public void validate(Object element, List parents, IWSDL11ValidationInfo valInfo) {
            for (WSDL11ValidatorDelegate delegate : this.validatorDelegates) {
                delegate.getValidator().validate(element, parents, valInfo);
            }
        }
    }
}

