/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.converter;

import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.property.converter.ExpressionConverter;
import org.eclipse.wb.internal.core.model.property.converter.StringConverter;

public final class StringArrayConverter
extends ExpressionConverter {
    public static final StringArrayConverter INSTANCE = new StringArrayConverter();

    private StringArrayConverter() {
    }

    @Override
    public String toJavaSource(JavaInfo javaInfo, Object value) {
        if (value == null) {
            return "(String[]) null";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("new String[] {");
        String[] items = (String[])value;
        int i = 0;
        while (i < items.length) {
            String item = items[i];
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(StringConverter.INSTANCE.toJavaSource(javaInfo, item));
            ++i;
        }
        buffer.append("}");
        return buffer.toString();
    }
}

