/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.layout.provider;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.AbstractLayoutEditPartProvider;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.Layout;
import org.eclipse.sirius.diagram.description.OrderedTreeLayout;
import org.eclipse.sirius.diagram.ui.tools.api.layout.provider.CompoundLayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.api.layout.provider.GridLayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.api.layout.provider.LayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.provider.AdjustedGridLayout;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.provider.ArrangeAllOnlyLayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.provider.BorderItemAwareLayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.provider.PinnedElementsLayoutProvider;

public class OrderedTreeLayoutProvider
implements LayoutProvider {
    private static final boolean PIN_MANAGEMENT_ON_TREE_LAYOUT = true;
    private GridLayoutProvider airGridLayoutProvider;

    @Override
    public AbstractLayoutEditPartProvider getLayoutNodeProvider(IGraphicalEditPart container) {
        ArrangeAllOnlyLayoutProvider layoutProvider = null;
        if (this.isDDiagramWithConfiguredOrderedTreeLayout(container)) {
            CompoundLayoutProvider clp = new CompoundLayoutProvider();
            GridLayoutProvider layoutNodeProvider = this.getGridLayoutProvider();
            clp.addProvider(layoutNodeProvider);
            clp.addProvider(new PinnedElementsLayoutProvider(layoutNodeProvider));
            BorderItemAwareLayoutProvider abstractLayoutProvider = new BorderItemAwareLayoutProvider(clp, true);
            layoutProvider = new ArrangeAllOnlyLayoutProvider(abstractLayoutProvider);
        }
        return layoutProvider;
    }

    @Override
    public boolean provides(IGraphicalEditPart container) {
        return this.isDDiagramWithConfiguredOrderedTreeLayout(container);
    }

    @Override
    public boolean isDiagramLayoutProvider() {
        return false;
    }

    private boolean isDDiagramWithConfiguredOrderedTreeLayout(IGraphicalEditPart container) {
        Layout layout;
        DDiagram vp;
        DiagramDescription desc;
        View view = container.getNotationView();
        EObject modelElement = view.getElement();
        return view instanceof Diagram && modelElement instanceof DDiagram && (desc = (vp = (DDiagram)modelElement).getDescription()) != null && (layout = desc.getLayout()) instanceof OrderedTreeLayout;
    }

    private GridLayoutProvider getGridLayoutProvider() {
        if (this.airGridLayoutProvider == null) {
            this.airGridLayoutProvider = new AdjustedGridLayout();
            this.airGridLayoutProvider.setColumnSizeMode(2);
            this.airGridLayoutProvider.setLineSizeMode(2);
            this.airGridLayoutProvider.getPadding().left = 10;
            this.airGridLayoutProvider.getPadding().right = 10;
        }
        return this.airGridLayoutProvider;
    }
}

