/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.bracket;

import java.util.List;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.sirius.diagram.ui.business.internal.bracket.BracketRelativeBendpoint;
import org.eclipse.sirius.diagram.ui.business.internal.bracket.Direction;

public final class DirectionUtil {
    private DirectionUtil() {
    }

    public static Direction getDirection(Point location, Point reference) {
        Direction direction = Direction.RIGHT;
        int diffX = location.x - reference.x;
        int diffY = location.y - reference.y;
        if (diffX == 0) {
            if (diffY < 0) {
                direction = Direction.TOP;
            } else if (diffY > 0) {
                direction = Direction.BOTTOM;
            }
        } else if (diffY == 0) {
            if (diffX > 0) {
                direction = Direction.RIGHT;
            } else if (diffX < 0) {
                direction = Direction.LEFT;
            }
        } else if (diffX > 0) {
            direction = diffY > 0 ? (diffX >= diffY ? Direction.RIGHT : Direction.BOTTOM) : (diffX >= -diffY ? Direction.RIGHT : Direction.TOP);
        } else if (diffX < 0) {
            direction = diffY > 0 ? (-diffX <= diffY ? Direction.BOTTOM : Direction.LEFT) : (-diffX >= -diffY ? Direction.LEFT : Direction.TOP);
        }
        return direction;
    }

    public static Direction getDirection(Connection connection) {
        List list;
        Direction direction = Direction.RIGHT;
        Object routingConstraint = connection.getRoutingConstraint();
        if (routingConstraint instanceof List && (list = (List)routingConstraint).size() == 1 && list.get(0) instanceof BracketRelativeBendpoint) {
            BracketRelativeBendpoint dimensionRelativeBendpoint = (BracketRelativeBendpoint)((Object)list.get(0));
            direction = Direction.values()[dimensionRelativeBendpoint.getDirection()];
        }
        return direction;
    }
}

