/*******************************************************************************
 * Copyright (c) 2007, 2012 THALES GLOBAL SERVICES.
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    Obeo - initial API and implementation
 *******************************************************************************/
package org.eclipse.sirius.diagram.ui.internal.edit.policies;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNode4EditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeListElementEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeListViewNodeListCompartment2EditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeListViewNodeListCompartmentEditPart;
import org.eclipse.sirius.diagram.ui.part.SiriusVisualIDRegistry;

import com.google.common.collect.Iterables;

/**
 * @was-generated
 */
public class DNodeListItemSemanticEditPolicy extends AbstractDDiagramElementContainerItemSemanticEditPolicy {

    /**
     * @was-generated
     */
    protected void addDestroyChildNodesCommand(CompoundCommand cmd) {
        View view = (View) getHost().getModel();
        EAnnotation annotation = view.getEAnnotation("Shortcut"); //$NON-NLS-1$
        if (annotation != null) {
            return;
        }
        for (Node node : Iterables.filter(view.getChildren(), Node.class)) {
            switch (SiriusVisualIDRegistry.getVisualID(node)) {
            case DNode4EditPart.VISUAL_ID:
                cmd.add(getDestroyElementCommand(node));
                break;
            case DNodeListViewNodeListCompartmentEditPart.VISUAL_ID:
            case DNodeListViewNodeListCompartment2EditPart.VISUAL_ID:
                for (Node cnode : Iterables.filter(node.getChildren(), Node.class)) {
                    switch (SiriusVisualIDRegistry.getVisualID(cnode)) {
                    case DNodeListElementEditPart.VISUAL_ID:
                        cmd.add(getDestroyElementCommand(cnode));
                        break;
                    }
                }
                break;
            default:
                break;
            }
        }
    }
}
