/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.core.engine;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.php.debug.core.debugger.IDebugHandler;
import org.eclipse.php.internal.debug.core.zend.debugger.CodeCoverageData;
import org.eclipse.php.internal.debug.core.zend.debugger.DebugError;
import org.eclipse.php.internal.debug.core.zend.debugger.IRemoteDebugger;
import org.eclipse.php.internal.debug.core.zend.model.ServerDebugHandler;
import org.eclipse.php.profile.core.PHPProfileCoreMessages;
import org.eclipse.php.profile.core.PHPProfileCorePlugin;
import org.eclipse.php.profile.core.data.ProfilerCallTrace;
import org.eclipse.php.profile.core.data.ProfilerData;
import org.eclipse.php.profile.core.data.ProfilerFileData;
import org.eclipse.php.profile.core.data.ProfilerGlobalData;
import org.eclipse.php.profile.core.engine.DefaultProfilerDB;
import org.eclipse.php.profile.core.engine.IProfiler;
import org.eclipse.php.profile.core.engine.ProfileSessionsManager;
import org.eclipse.php.profile.core.engine.ProfilerDB;
import org.eclipse.php.profile.core.engine.ProfilerDBManager;
import org.eclipse.php.profile.core.engine.ZRemoteProfiler;

public class ZProfiler
extends ServerDebugHandler
implements IProfiler,
IDebugHandler {
    private ProfilerDBManager fDBManager;
    private String fAdditionalOptions = "";
    private boolean fParsingErrorOccurred;

    protected IRemoteDebugger createRemoteDebugger() {
        return new ZRemoteProfiler(this, this.fDebugConnection);
    }

    public ProfilerDB getProfilerDB() {
        return this.fDBManager;
    }

    @Override
    public ProfilerGlobalData getProfilerGlobalData() {
        ZRemoteProfiler remoteProfiler = (ZRemoteProfiler)this.getRemoteDebugger();
        return remoteProfiler.getProfilerGlobalData();
    }

    @Override
    public ProfilerFileData getProfilerFileData(int fileNumber) {
        ZRemoteProfiler remoteProfiler = (ZRemoteProfiler)this.getRemoteDebugger();
        return remoteProfiler.getProfilerFileData(fileNumber);
    }

    @Override
    public ProfilerCallTrace getProfilerCallTrace() {
        ZRemoteProfiler remoteProfiler = (ZRemoteProfiler)this.getRemoteDebugger();
        return remoteProfiler.getProfilerCallTrace();
    }

    @Override
    public ProfilerData getProfilerData() {
        ZRemoteProfiler remoteProfiler = (ZRemoteProfiler)this.getRemoteDebugger();
        return remoteProfiler.getProfilerData();
    }

    public void handleScriptEnded() {
        try {
            try {
                if (this.fParsingErrorOccurred) {
                    super.handleScriptEnded();
                } else {
                    Job profileJob = new Job(PHPProfileCoreMessages.ZProfiler_0){

                        protected IStatus run(IProgressMonitor monitor) {
                            if (!monitor.isCanceled()) {
                                try {
                                    ZProfiler.this.fDBManager = new ProfilerDBManager(new DefaultProfilerDB(ZProfiler.this));
                                    ProfilerGlobalData globalData = ZProfiler.this.fDBManager.getGlobalData();
                                    if (globalData != null) {
                                        globalData.setOptions(ZProfiler.this.fAdditionalOptions);
                                    }
                                }
                                finally {
                                    monitor.done();
                                }
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    profileJob.schedule();
                    profileJob.join();
                    super.handleScriptEnded();
                    if (this.fDBManager.getGlobalData() != null) {
                        CodeCoverageData[] codeCoverageData = this.getLastCodeCoverageData();
                        if (codeCoverageData != null) {
                            int i = 0;
                            while (i < codeCoverageData.length) {
                                ProfilerFileData fileData = this.fDBManager.getFileData(codeCoverageData[i].getFileName());
                                if (fileData != null) {
                                    fileData.setCodeCoverageData(codeCoverageData[i]);
                                }
                                ++i;
                            }
                        }
                        ProfileSessionsManager.addSession(this.fDBManager);
                    }
                }
            }
            catch (Exception e) {
                PHPProfileCorePlugin.log(e);
                this.getDebugTarget().terminated();
            }
        }
        finally {
            this.getDebugTarget().terminated();
        }
    }

    public void sessionStarted(String fileName, String uri, String query, String options) {
        super.sessionStarted(fileName, uri, query, options);
        this.fParsingErrorOccurred = false;
    }

    public void parsingErrorOccured(DebugError debugError) {
        if (DebugError.isError((DebugError)debugError)) {
            this.fParsingErrorOccurred = true;
        }
        super.parsingErrorOccured(debugError);
    }
}

