/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.abstractviewers;

import java.text.NumberFormat;
import org.eclipse.linuxtools.dataviewers.abstractviewers.AbstractSTDataViewersField;
import org.eclipse.linuxtools.dataviewers.listeners.ISpecialDrawerListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractPercentageDrawerField
extends AbstractSTDataViewersField
implements ISpecialDrawerListener {
    @Override
    public ISpecialDrawerListener getSpecialDrawer(Object obj) {
        return this;
    }

    @Override
    public String getValue(Object obj) {
        return "" + this.getPercentage(obj);
    }

    public abstract float getPercentage(Object var1);

    public void handleEvent(Event event) {
        Item item = (Item)event.item;
        Display display = event.widget.getDisplay();
        int index = event.index;
        int widthcol = 0;
        Widget widget = event.widget;
        if (widget instanceof Tree) {
            Tree tree = (Tree)widget;
            widthcol = tree.getColumn(index).getWidth();
        } else {
            Table table = (Table)event.widget;
            widthcol = table.getColumn(index).getWidth();
        }
        float d = this.getPercentage(item.getData());
        int percent = (int)((double)d + 0.5);
        GC gc = event.gc;
        int totalProgBarLength = (int)((double)widthcol * 0.3);
        if (totalProgBarLength > 0) {
            int totalProgBarHeight = (int)((double)event.height * 0.5);
            gc.setBackground(display.getSystemColor(6));
            int progBarGreenWidth = (int)((double)totalProgBarLength * ((double)percent * 0.01));
            int progBarGreenHorizontalPos = event.x;
            int progBarGreenHeight = (int)((double)event.height * 0.5);
            int progBarGreenVerticalPos = event.y + totalProgBarHeight / 2 + 1;
            gc.fillRectangle(progBarGreenHorizontalPos, progBarGreenVerticalPos, progBarGreenWidth, progBarGreenHeight);
            gc.setBackground(display.getSystemColor(4));
            int progBarRedWidth = totalProgBarLength - progBarGreenWidth;
            int progBarRedHorizontalPos = progBarGreenHorizontalPos + progBarGreenWidth;
            int progBarRedHeight = progBarGreenHeight;
            int progBarRedVerticalPos = progBarGreenVerticalPos;
            gc.fillRectangle(progBarRedHorizontalPos, progBarRedVerticalPos, progBarRedWidth, progBarRedHeight);
        }
        Object text = "%";
        text = String.valueOf(this.isSettedNumberFormat() ? this.getNumberFormat().format(d) : Float.valueOf(d)) + (String)text;
        Point size = gc.textExtent((String)text);
        int offset = Math.max(0, (event.height - size.y) / 2);
        Color foreground = gc.getForeground();
        gc.setForeground(display.getSystemColor(24));
        int progBarOffset = totalProgBarLength + widthcol / 20;
        gc.drawText((String)text, event.x + progBarOffset, event.y + offset, true);
        gc.setForeground(foreground);
    }

    public abstract NumberFormat getNumberFormat();

    public abstract boolean isSettedNumberFormat();
}

