/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.actions.link;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.actions.link.ILinkCreator;
import org.eclipse.jst.pagedesigner.viewer.DesignRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

class LinkWizardPage
extends WizardPage {
    private static final String GROUP_TITLE = PDPlugin.getResourceString("LinkWizardPage.GroupTitle");
    private static final String PREVIEW_TAG_LABEL = PDPlugin.getResourceString("LinkWizardPage.PreviewLabel");
    private StyledText _text = null;
    private final Map<String, ILinkCreator> _linkMap;
    private String _linkType = null;
    private final EditPart _part;
    private final DesignRange _range;

    public LinkWizardPage(String pageName, String title, EditPart editPart, DesignRange range, Map<String, ILinkCreator> linkMap) {
        super(pageName, title, null);
        this._part = editPart;
        this._range = range;
        this._linkMap = linkMap;
    }

    public void createControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 20;
        parent.setLayout((Layout)layout);
        GridData data = new GridData(1810);
        parent.setLayoutData((Object)data);
        Group group = new Group(parent, 0);
        group.setText(GROUP_TITLE);
        layout = new GridLayout();
        group.setLayout((Layout)layout);
        data = new GridData(768);
        group.setLayoutData((Object)data);
        Object defaultLink = "";
        Set<String> set = this._linkMap.keySet();
        int size = set.size();
        Object[] keys = new String[size];
        Iterator<String> itr = set.iterator();
        int i = 0;
        while (itr.hasNext()) {
            String key = itr.next();
            keys[i++] = key;
        }
        Arrays.sort(keys);
        int j = 0;
        while (j < size) {
            Button bt = new Button((Composite)group, 16);
            data = new GridData(768);
            bt.setLayoutData((Object)data);
            bt.setText((String)keys[j]);
            if (j == 0) {
                bt.setSelection(true);
                defaultLink = keys[j];
            }
            bt.addSelectionListener((SelectionListener)new SelectLinkListener((String)keys[j]));
            ++j;
        }
        Label label = new Label(parent, 0);
        label.setText(PREVIEW_TAG_LABEL);
        this._text = new StyledText(parent, 2624);
        data = new GridData(1808);
        data.heightHint = 50;
        this._text.setLayoutData((Object)data);
        ILinkCreator creator = this._linkMap.get(defaultLink);
        this._linkType = creator.getLinkIdentifier();
        String previewText = creator.getSourcePreview(this._part, this._range);
        previewText = previewText == null ? "" : previewText;
        this._text.setText(previewText);
        this._text.setEditable(false);
        super.setControl((Control)group);
    }

    public boolean isPageComplete() {
        return true;
    }

    public String getChosenLinkType() {
        return this._linkType;
    }

    class SelectLinkListener
    extends SelectionAdapter {
        private String _key;

        public SelectLinkListener(String key) {
            this._key = key;
        }

        public void widgetSelected(SelectionEvent e) {
            ILinkCreator creator = LinkWizardPage.this._linkMap.get(this._key);
            LinkWizardPage.this._linkType = creator.getLinkIdentifier();
            String previewText = creator.getSourcePreview(LinkWizardPage.this._part, LinkWizardPage.this._range);
            previewText = previewText == null ? "" : previewText;
            LinkWizardPage.this._text.setText(previewText);
            super.widgetSelected(e);
        }
    }
}

