/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.internal.command;

import org.eclipse.graphiti.IReadOnly;
import org.eclipse.graphiti.IReadOnlyProvider;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureHolder;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.internal.Messages;
import org.eclipse.graphiti.internal.command.ICommand;

public abstract class FeatureCommand
implements ICommand,
IFeatureHolder,
IReadOnlyProvider {
    private static final String NO_FEATURE = Messages.FeatureCommand_0_xmsg;
    private final IFeature feature;

    public FeatureCommand(IFeature feature) {
        if (feature == null) {
            throw new IllegalArgumentException("feature must not be null");
        }
        this.feature = feature;
    }

    @Override
    public IFeature getFeature() {
        return this.feature;
    }

    @Override
    public String getDescription() {
        IFeature f = this.getFeature();
        if (f != null) {
            return f.getName();
        }
        return NO_FEATURE;
    }

    @Override
    public IFeatureProvider getFeatureProvider() {
        return this.getFeature().getFeatureProvider();
    }

    @Override
    public boolean isReadOnly() {
        boolean ret = false;
        IFeature f = this.getFeature();
        if (f != null && f instanceof IReadOnly) {
            ret = true;
        }
        return ret;
    }
}

