/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.graph.editparts;

import org.eclipse.datatools.modelbase.sql.query.QuerySelect;
import org.eclipse.datatools.modelbase.sql.query.TableCorrelation;
import org.eclipse.datatools.modelbase.sql.query.TableExpression;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionColumn;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.sqltools.sqlbuilder.views.graph.commands.CreateJoinCommand;
import org.eclipse.datatools.sqltools.sqlbuilder.views.graph.commands.MoveJoinCommand;
import org.eclipse.datatools.sqltools.sqlbuilder.views.graph.editparts.ColumnEditPart;
import org.eclipse.datatools.sqltools.sqlbuilder.views.graph.editparts.JoinEditPart;
import org.eclipse.datatools.sqltools.sqlbuilder.views.graph.figures.FlatEndConnectionRouter;
import org.eclipse.datatools.sqltools.sqlbuilder.views.graph.figures.TableConnection;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;

public class ColumnEditPolicy
extends GraphicalNodeEditPolicy {
    public static final Display display = Display.getDefault();
    private static Font tooltipFont = display.getSystemFont();
    protected Figure fTargetFeedback;
    protected Figure fSourceDataType;
    protected Figure fTargetDataType;
    protected QuerySelect selectStatement;

    public ColumnEditPolicy(QuerySelect selectStatement) {
        this.selectStatement = selectStatement;
    }

    protected Connection createDummyConnection(Request req) {
        ColumnEditPart columnPart;
        String toolTip;
        TableConnection conn = new TableConnection();
        conn.setConnectionRouter(new FlatEndConnectionRouter());
        GraphicalEditPart hostEditPart = this.getHost();
        if (hostEditPart instanceof ColumnEditPart && !(toolTip = (columnPart = (ColumnEditPart)hostEditPart).getToolTip()).equals("")) {
            this.fSourceDataType = this.createToolTip(columnPart.getLabel().getBounds().getExpanded(0, 0).getBottomLeft().translate(0, 2), toolTip);
        }
        return conn;
    }

    protected void eraseCreationFeedback(CreateConnectionRequest request) {
        if (this.fSourceDataType != null) {
            this.removeFeedback((IFigure)this.fSourceDataType);
            this.fSourceDataType = null;
        }
        super.eraseCreationFeedback(request);
    }

    protected void eraseTargetConnectionFeedback(DropRequest request) {
        if (this.fTargetFeedback != null) {
            this.removeFeedback((IFigure)this.fTargetFeedback);
            this.fTargetFeedback = null;
        }
        if (this.fTargetDataType != null) {
            this.removeFeedback((IFigure)this.fTargetDataType);
            this.fTargetDataType = null;
        }
    }

    protected ColumnEditPart getColumnEditPart() {
        return (ColumnEditPart)this.getHost();
    }

    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        CreateJoinCommand command = (CreateJoinCommand)request.getStartCommand();
        if (command == null) {
            return null;
        }
        command.setTargetTable(this.getTableExpr());
        command.setTargetColumn(this.getColumnExpr());
        return command;
    }

    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        CreateJoinCommand command = new CreateJoinCommand();
        request.setStartCommand((Command)command);
        command.setSelectStatement(this.selectStatement);
        command.setSourceTable(this.getTableExpr());
        command.setSourceColumn(this.getColumnExpr());
        return command;
    }

    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        MoveJoinCommand cmd = new MoveJoinCommand();
        cmd.setJoinPart((JoinEditPart)request.getConnectionEditPart());
        cmd.setSelectStatement(this.selectStatement);
        cmd.setColumnPart(this.getColumnEditPart());
        cmd.setChangeSource(true);
        return cmd;
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        MoveJoinCommand cmd = new MoveJoinCommand();
        cmd.setJoinPart((JoinEditPart)request.getConnectionEditPart());
        cmd.setColumnPart(this.getColumnEditPart());
        cmd.setSelectStatement(this.selectStatement);
        cmd.setChangeSource(false);
        return cmd;
    }

    protected Column getRDBColumn() {
        return (Column)this.getHost().getModel();
    }

    protected ValueExpressionColumn getColumnExpr() {
        ValueExpressionColumn colExpr = null;
        Object modelObj = this.getHost().getModel();
        if (modelObj instanceof ValueExpressionColumn) {
            colExpr = (ValueExpressionColumn)modelObj;
        }
        return colExpr;
    }

    protected TableCorrelation getSQLCorrelation() {
        return ((ColumnEditPart)this.getHost()).getTableEditPart().getTableAlias();
    }

    private TableExpression getTableExpr() {
        TableExpression tblExpr = null;
        Object modelObj = ((ColumnEditPart)this.getHost()).getTableEditPart().getModel();
        if (modelObj instanceof TableExpression) {
            tblExpr = (TableExpression)modelObj;
        }
        return tblExpr;
    }

    protected void showTargetConnectionFeedback(DropRequest request) {
        if (this.fTargetFeedback == null) {
            ColumnEditPart columnPart;
            String toolTip;
            GraphicalEditPart hostEditPart = this.getHost();
            RectangleFigure rectFig = new RectangleFigure();
            rectFig.setLineStyle(3);
            rectFig.setFill(false);
            IFigure f = hostEditPart.getFigure();
            rectFig.setBounds(f.getBounds().getExpanded(0, 0));
            this.addFeedback((IFigure)rectFig);
            this.fTargetFeedback = rectFig;
            if (hostEditPart instanceof ColumnEditPart && !(toolTip = (columnPart = (ColumnEditPart)hostEditPart).getToolTip()).equals("")) {
                this.fTargetDataType = this.createToolTip(request.getLocation().translate(0, 15), toolTip);
            }
        }
    }

    private Figure createToolTip(Point location, String toolTipText) {
        Label toolTipFigure = new Label(toolTipText);
        toolTipFigure.setFont(tooltipFont);
        toolTipFigure.setBorder((Border)new LineBorder());
        toolTipFigure.setSize(toolTipFigure.getPreferredSize().getExpanded(2, 2));
        toolTipFigure.setLocation(location);
        toolTipFigure.setForegroundColor(ColorConstants.tooltipForeground);
        toolTipFigure.setBackgroundColor(ColorConstants.tooltipBackground);
        toolTipFigure.setOpaque(true);
        this.addFeedback((IFigure)toolTipFigure);
        return toolTipFigure;
    }
}

