/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.visualizer.ui.canvas;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.cdt.visualizer.ui.canvas.GraphicObject;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class VirtualBoundsGraphicObject
extends GraphicObject {
    protected Rectangle m_virtualBounds = new Rectangle(0, 0, 0, 0);
    protected ArrayList<VirtualBoundsGraphicObject> m_childrenObjects = new ArrayList();
    protected HashMap<String, VirtualBoundsGraphicObject> m_childrenObjectsMap = new HashMap();
    protected boolean m_drawContainerBounds = true;
    protected boolean m_selectable = false;
    protected Color m_selectedColor = null;
    protected int m_childMargin = 0;
    protected static final int MARGIN_PIXELS_DEFAULT = 1;

    public VirtualBoundsGraphicObject() {
        this(false, 1);
    }

    public VirtualBoundsGraphicObject(boolean selectable, int childMargin) {
        this.m_selectable = selectable;
        this.setDrawContainerBounds(true);
        this.m_childMargin = childMargin;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.m_childrenObjects != null) {
            for (VirtualBoundsGraphicObject o : this.m_childrenObjects) {
                o.dispose();
            }
            this.m_childrenObjects.clear();
            this.m_childrenObjects = null;
        }
        if (this.m_childrenObjectsMap != null) {
            this.m_childrenObjectsMap.clear();
            this.m_childrenObjectsMap = null;
        }
    }

    public String toString() {
        return String.format("Class: %s, Real bounds: %s, Virtual bounds: %s, Draw container bounds: %s ", this.getClass().getSimpleName(), this.getBounds().toString(), this.m_virtualBounds.toString(), this.m_drawContainerBounds);
    }

    public void setDrawContainerBounds(boolean draw) {
        this.m_drawContainerBounds = draw;
    }

    public void setSelectable(boolean sel) {
        this.m_selectable = sel;
    }

    public boolean isSelectable() {
        return this.m_selectable;
    }

    public void setSelectedColor(Color color) {
        this.m_selectedColor = color;
    }

    public Color getSelectedColor() {
        return this.m_selectedColor;
    }

    public void setChildMargin(int margin) {
        this.m_childMargin = margin;
    }

    @Override
    public void setBounds(Rectangle bounds) {
        this.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        for (VirtualBoundsGraphicObject o : this.m_childrenObjects) {
            o.setBounds(this.virtualToRealBounds(o.getVirtualBounds()));
        }
    }

    public void setVirtualBounds(int[] bounds) {
        this.m_virtualBounds.x = bounds[0];
        this.m_virtualBounds.y = bounds[1];
        this.m_virtualBounds.width = bounds[2];
        this.m_virtualBounds.height = bounds[3];
        this.checkVirtualBounds();
    }

    public void setVirtualBounds(Rectangle bounds) {
        this.m_virtualBounds = bounds;
        this.checkVirtualBounds();
    }

    public void setVirtualBounds(int x, int y, int width, int height) {
        this.m_virtualBounds.x = x;
        this.m_virtualBounds.y = y;
        this.m_virtualBounds.width = width;
        this.m_virtualBounds.height = height;
        this.checkVirtualBounds();
    }

    public Rectangle getVirtualBounds() {
        return this.m_virtualBounds;
    }

    private void checkVirtualBounds() {
        if (this.m_virtualBounds.x < 0) {
            throw new IllegalArgumentException("Illegal x: " + this.m_virtualBounds.x);
        }
        if (this.m_virtualBounds.y < 0) {
            throw new IllegalArgumentException("Illegal y: " + this.m_virtualBounds.y);
        }
        if (this.m_virtualBounds.width <= 0) {
            throw new IllegalArgumentException("Illegal width: " + this.m_virtualBounds.width);
        }
        if (this.m_virtualBounds.height <= 0) {
            throw new IllegalArgumentException("Illegal height: " + this.m_virtualBounds.height);
        }
    }

    public Rectangle virtualToRealBounds(Rectangle childsVirtualBounds) {
        float ox = 0.0f;
        float oy = 0.0f;
        float ow = 0.0f;
        float oh = 0.0f;
        ox = (float)this.getBounds().x + (float)childsVirtualBounds.x * ((float)this.getBounds().width / (float)this.getVirtualBounds().width);
        oy = (float)this.getBounds().y + (float)childsVirtualBounds.y * ((float)this.getBounds().height / (float)this.getVirtualBounds().height);
        ow = (float)childsVirtualBounds.width / (float)this.getVirtualBounds().width * (float)this.getBounds().width;
        oh = (float)childsVirtualBounds.height / (float)this.getVirtualBounds().height * (float)this.getBounds().height;
        ow = ow > 0.0f ? (ow -= (float)(2 * this.m_childMargin)) : 0.0f;
        oh = oh > 0.0f ? (oh -= (float)(2 * this.m_childMargin)) : 0.0f;
        return new Rectangle(Math.round(ox += (float)this.m_childMargin), Math.round(oy += (float)this.m_childMargin), Math.round(ow), Math.round(oh));
    }

    public VirtualBoundsGraphicObject addChildObject(String label, VirtualBoundsGraphicObject obj) {
        this.m_childrenObjects.add(obj);
        this.m_childrenObjectsMap.put(label, obj);
        return obj;
    }

    public ArrayList<VirtualBoundsGraphicObject> getChildObjects(Class<?> type, boolean recurse) {
        ArrayList<VirtualBoundsGraphicObject> objs = new ArrayList<VirtualBoundsGraphicObject>();
        for (VirtualBoundsGraphicObject o : this.getAllObjects(recurse)) {
            if (!type.isInstance(o)) continue;
            objs.add(o);
        }
        return objs;
    }

    public VirtualBoundsGraphicObject getObject(String label) {
        return this.getObject(label, true);
    }

    public VirtualBoundsGraphicObject getObject(String label, boolean recurse) {
        if (this.m_childrenObjectsMap.containsKey(label)) {
            return this.m_childrenObjectsMap.get(label);
        }
        if (recurse) {
            for (VirtualBoundsGraphicObject o : this.m_childrenObjects) {
                if (o.getObject(label) == null) continue;
                return o.getObject(label, true);
            }
        }
        return null;
    }

    public ArrayList<VirtualBoundsGraphicObject> getAllObjects(boolean recurse) {
        ArrayList<VirtualBoundsGraphicObject> list = new ArrayList<VirtualBoundsGraphicObject>();
        for (VirtualBoundsGraphicObject o : this.m_childrenObjects) {
            list.add(o);
            if (!recurse) continue;
            list.addAll(o.getAllObjects(recurse));
        }
        return list;
    }

    public List<VirtualBoundsGraphicObject> getSelectableObjects() {
        ArrayList<VirtualBoundsGraphicObject> list = new ArrayList<VirtualBoundsGraphicObject>();
        for (VirtualBoundsGraphicObject o : this.m_childrenObjects) {
            if (o.isSelectable()) {
                list.add(o);
            }
            list.addAll(o.getSelectableObjects());
        }
        return list;
    }

    public boolean hasChildrenWithDecorations() {
        for (VirtualBoundsGraphicObject o : this.getAllObjects(false)) {
            if (!o.hasDecorations()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void paint(GC gc, boolean decorations) {
        Color oldForeground = null;
        Color oldBackground = null;
        if (this.m_foreground != null) {
            oldForeground = gc.getForeground();
            gc.setForeground(this.m_foreground);
        }
        if (this.m_background != null) {
            oldBackground = gc.getBackground();
            gc.setBackground(this.m_background);
        }
        if (!decorations) {
            if (this.isVisible()) {
                this.paintContent(gc);
            }
        } else if (this.isVisible() && this.hasDecorations()) {
            this.paintDecorations(gc);
        }
        if (this.m_childrenObjects != null) {
            for (VirtualBoundsGraphicObject o : this.m_childrenObjects) {
                o.paint(gc, decorations);
            }
        }
        if (this.m_foreground != null && oldForeground != null) {
            gc.setForeground(oldForeground);
        }
        if (this.m_background != null && oldBackground != null) {
            gc.setBackground(oldBackground);
        }
    }

    @Override
    public void paintContent(GC gc) {
        if (this.m_drawContainerBounds) {
            if (this.isSelected() && this.m_selectedColor != null) {
                gc.setForeground(this.m_selectedColor);
            } else {
                gc.setForeground(this.m_foreground);
            }
            gc.setBackground(this.m_background);
            gc.fillRectangle(this.m_bounds);
            super.paintContent(gc);
        }
    }

    @Override
    public boolean hasDecorations() {
        return this.hasChildrenWithDecorations();
    }
}

