/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.gef.core;

import org.eclipse.draw2d.EventListenerList;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Tool;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.wb.gef.core.ICommandExceptionHandler;
import org.eclipse.wb.gef.graphical.tools.SelectionTool;
import org.eclipse.wb.internal.gef.core.CancelOperationError;
import org.eclipse.wb.internal.gef.core.IActiveToolListener;
import org.eclipse.wb.internal.gef.core.IDefaultToolProvider;

public class EditDomain
extends org.eclipse.gef.EditDomain {
    private org.eclipse.wb.gef.core.tools.Tool m_activeTool;
    private org.eclipse.wb.gef.core.tools.Tool m_defaultTool;
    private EditPartViewer m_currentViewer;
    private MouseEvent m_currentMouseEvent;
    private ICommandExceptionHandler m_exceptionHandler;
    private org.eclipse.wb.gef.core.tools.Tool m_inCommandTool;
    private IDefaultToolProvider m_defaultToolProvider;
    private EventListenerList m_eventTable;

    public EditDomain() {
        this.setCommandStack(new DesignerCommandStack());
    }

    private void clearToolDuringCommandExecution() {
        if (this.m_activeTool != null) {
            this.m_inCommandTool = this.m_activeTool;
            this.m_activeTool = null;
        }
    }

    private void restoreToolAfterCommandExecution() {
        if (this.m_activeTool == null) {
            this.m_activeTool = this.m_inCommandTool;
        }
    }

    public void setExceptionHandler(ICommandExceptionHandler exceptionHandler) {
        this.m_exceptionHandler = exceptionHandler;
    }

    private EventListenerList getEventTable() {
        if (this.m_eventTable == null) {
            this.m_eventTable = new EventListenerList();
        }
        return this.m_eventTable;
    }

    public void setDefaultToolProvider(IDefaultToolProvider toolListener) {
        this.m_defaultToolProvider = toolListener;
    }

    public void addActiveToolListener(IActiveToolListener listener) {
        this.getEventTable().addListener(IActiveToolListener.class, (Object)listener);
    }

    public void removeActiveToolListener(IActiveToolListener listener) {
        this.getEventTable().removeListener(IActiveToolListener.class, (Object)listener);
    }

    public void loadDefaultTool() {
        if (this.m_defaultToolProvider != null) {
            this.m_defaultToolProvider.loadDefaultTool();
        } else {
            this.setActiveTool((Tool)this.getDefaultTool());
        }
    }

    public org.eclipse.wb.gef.core.tools.Tool getDefaultTool() {
        if (this.m_defaultTool == null) {
            this.m_defaultTool = new SelectionTool();
        }
        return this.m_defaultTool;
    }

    public void setDefaultTool(Tool defaultTool) {
        this.m_defaultTool = (org.eclipse.wb.gef.core.tools.Tool)defaultTool;
    }

    public org.eclipse.wb.gef.core.tools.Tool getActiveTool() {
        return this.m_activeTool;
    }

    public void setActiveTool(Tool activeTool) {
        if (this.m_activeTool != null) {
            this.m_activeTool.deactivate();
        }
        this.m_activeTool = (org.eclipse.wb.gef.core.tools.Tool)activeTool;
        if (this.m_activeTool != null) {
            this.m_activeTool.setEditDomain(this);
            this.m_activeTool.activate();
            for (IActiveToolListener listener : this.getEventTable().getListenersIterable(IActiveToolListener.class)) {
                listener.toolActivated(this.m_activeTool);
            }
            if (this.m_currentViewer != null) {
                this.m_activeTool.setViewer(this.m_currentViewer);
                this.m_activeTool.mouseMove(this.m_currentMouseEvent, this.m_currentViewer);
            }
        }
    }

    public void mouseDoubleClick(MouseEvent event, EditPartViewer viewer) {
        this.m_currentMouseEvent = event;
        super.mouseDoubleClick(event, viewer);
    }

    public void mouseDown(MouseEvent event, EditPartViewer viewer) {
        this.m_currentMouseEvent = event;
        super.mouseDown(event, viewer);
    }

    public void mouseUp(MouseEvent event, EditPartViewer viewer) {
        this.m_currentMouseEvent = event;
        super.mouseUp(event, viewer);
    }

    public void mouseMove(MouseEvent event, EditPartViewer viewer) {
        this.m_currentMouseEvent = event;
        super.mouseMove(event, viewer);
    }

    public void mouseDrag(MouseEvent event, EditPartViewer viewer) {
        this.m_currentMouseEvent = event;
        super.mouseDrag(event, viewer);
    }

    public void viewerEntered(MouseEvent event, EditPartViewer viewer) {
        this.m_currentMouseEvent = event;
        this.m_currentViewer = viewer;
        super.viewerEntered(event, viewer);
    }

    public void viewerExited(MouseEvent event, EditPartViewer viewer) {
        this.m_currentMouseEvent = event;
        this.m_currentViewer = null;
        super.viewerExited(event, viewer);
    }

    private class DesignerCommandStack
    extends CommandStack {
        private DesignerCommandStack() {
        }

        public void execute(Command command) {
            EditDomain.this.clearToolDuringCommandExecution();
            try {
                try {
                    if (System.getProperty("wbp.EditDomain.simulateCommandException") != null) {
                        throw new Error("Simulated exception.");
                    }
                    super.execute(command);
                }
                catch (Throwable e) {
                    if (EditDomain.this.m_exceptionHandler != null) {
                        EditDomain.this.m_exceptionHandler.handleException(e);
                        throw new CancelOperationError();
                    }
                    EditDomain.this.restoreToolAfterCommandExecution();
                }
            }
            finally {
                EditDomain.this.restoreToolAfterCommandExecution();
            }
        }
    }
}

