/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.uml.internal;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.ocl.uml.internal.OCLDebugOptions;

public class OCLUMLPlugin
extends EMFPlugin {
    public static final String EMPTY_STRING = "";
    private static final String PREFIX_THROWING = "THROWN ";
    private static final String SEPARATOR_SPACE = " ";
    private static final String PARENTHESIS_OPEN = "(";
    private static final String PARENTHESIS_CLOSE = ")";
    private static final String SEPARATOR_METHOD = "#";
    private static final String PREFIX_CATCHING = "CAUGHT ";
    public static OCLUMLPlugin INSTANCE = new OCLUMLPlugin();
    private static Implementation plugin;

    public OCLUMLPlugin() {
        super(new ResourceLocator[0]);
    }

    public static String getPluginId() {
        return OCLUMLPlugin.getPlugin() != null ? OCLUMLPlugin.getPlugin().getBundle().getSymbolicName() : "org.eclipse.ocl.uml";
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    public static OCLUMLPlugin getInstance() {
        return INSTANCE;
    }

    public static void catching(Class<?> clazz, String methodName, Throwable throwable) {
        if (OCLUMLPlugin.shouldTrace(OCLDebugOptions.EXCEPTIONS_CATCHING)) {
            System.out.println(PREFIX_CATCHING + throwable.getMessage() + SEPARATOR_SPACE + PARENTHESIS_OPEN + clazz.getName() + SEPARATOR_METHOD + methodName + PARENTHESIS_CLOSE);
            throwable.printStackTrace(System.err);
        }
    }

    public static void throwing(Class<?> clazz, String methodName, Throwable throwable) {
        if (OCLUMLPlugin.shouldTrace(OCLDebugOptions.EXCEPTIONS_THROWING)) {
            System.out.println(PREFIX_THROWING + throwable.getMessage() + SEPARATOR_SPACE + PARENTHESIS_OPEN + clazz.getName() + SEPARATOR_METHOD + methodName + PARENTHESIS_CLOSE);
            throwable.printStackTrace(System.err);
        }
    }

    public static boolean shouldTrace(String option) {
        if (OCLUMLPlugin.getPlugin() != null) {
            if (OCLUMLPlugin.getPlugin().isDebugging()) {
                return Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)option));
            }
            return false;
        }
        return Boolean.getBoolean("org.eclipse.ocl.uml.debug");
    }

    public static void error(int code, String message) {
        OCLUMLPlugin.error(code, message, null);
    }

    public static void error(int code, String message, Throwable throwable) {
        OCLUMLPlugin.log(4, code, message, throwable);
    }

    public static void info(String message) {
        OCLUMLPlugin.info(0, message);
    }

    public static void info(int code, String message) {
        OCLUMLPlugin.info(code, message, null);
    }

    public static void info(int code, String message, Throwable throwable) {
        OCLUMLPlugin.log(1, code, message, throwable);
    }

    public static void warning(int code, String message) {
        OCLUMLPlugin.warning(code, message, null);
    }

    public static void warning(int code, String message, Throwable throwable) {
        OCLUMLPlugin.log(2, code, message, throwable);
    }

    public static void log(int severity, int code, String message, Throwable throwable) {
        String msg = message == null ? EMPTY_STRING : message;
        try {
            if (OCLUMLPlugin.getPlugin() != null) {
                OCLUMLPlugin.getPlugin().log(new Status(severity, OCLUMLPlugin.getPluginId(), code, msg, throwable));
            } else if (OCLUMLPlugin.shouldTrace(OCLDebugOptions.DEBUG)) {
                switch (code) {
                    case 2: {
                        System.err.print("WARNING ");
                        break;
                    }
                    case 4: 
                    case 8: {
                        System.err.print("ERROR ");
                        break;
                    }
                    default: {
                        return;
                    }
                }
                System.err.print(code);
                System.err.print(": ");
                System.err.println(message);
                if (throwable != null) {
                    throwable.printStackTrace(System.err);
                }
            }
        }
        catch (IllegalArgumentException iae) {
            OCLUMLPlugin.catching(OCLUMLPlugin.class, "log", iae);
        }
    }

    static /* synthetic */ Implementation access$0() {
        return plugin;
    }

    public static class Implementation
    extends EMFPlugin.EclipsePlugin {
        public Implementation() {
            plugin = this;
        }
    }
}

