/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.workflow.ui.internal;

import org.eclipse.modisco.workflow.ui.internal.Activator;
import org.eclipse.modisco.workflow.ui.internal.Messages;
import org.eclipse.modisco.workflow.ui.internal.WorkflowTab;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class WorkflowTableContextMenu {
    private Menu menuSelection;
    private Menu menuNoSelection;
    private final WorkflowTab workflowTab;

    public WorkflowTableContextMenu(WorkflowTab workflowTab) {
        this.workflowTab = workflowTab;
    }

    public void createPopupMenuSelectionItem(Shell shell) {
        if (this.menuSelection == null) {
            this.menuSelection = new Menu((Decorations)shell, 8);
            MenuItem itemRemove = new MenuItem(this.menuSelection, 8);
            itemRemove.setText(Messages.ContextualMenuInWorkflowTable_Remove);
            itemRemove.setImage(Activator.getImageDescriptor("icons/deleteWork.png").createImage());
            itemRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WorkflowTableContextMenu.this.getButtonComposite().removeWork();
                }
            });
            MenuItem itemUp = new MenuItem(this.menuSelection, 8);
            itemUp.setText(Messages.ContextualMenuInWorkflowTable_Up);
            itemUp.setImage(Activator.getImageDescriptor("icons/upWork.png").createImage());
            itemUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WorkflowTableContextMenu.this.getButtonComposite().moveWorkUp();
                }
            });
            MenuItem itemDown = new MenuItem(this.menuSelection, 8);
            itemDown.setText(Messages.ContextualMenuInWorkflowTable_Down);
            itemDown.setImage(Activator.getImageDescriptor("icons/downWork.png").createImage());
            itemDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WorkflowTableContextMenu.this.getButtonComposite().moveWorkDown();
                }
            });
            itemRemove.setEnabled(true);
            itemUp.setEnabled(true);
            itemDown.setEnabled(true);
        }
    }

    public void createPopupMenuNoSelectionItem(Shell shell) {
        if (this.menuNoSelection == null) {
            this.menuNoSelection = new Menu((Decorations)shell, 8);
            MenuItem itemLoad = new MenuItem(this.menuNoSelection, 8);
            itemLoad.setText(Messages.ContextualMenuInWorkflowTable_Load);
            itemLoad.setImage(Activator.getImageDescriptor("icons/loadWork.png").createImage());
            itemLoad.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WorkflowTableContextMenu.this.getButtonComposite().loadAdditionalWork();
                }
            });
            itemLoad.setEnabled(true);
        }
    }

    public Menu getMenuSelection() {
        return this.menuSelection;
    }

    public Menu getMenuNoSelection() {
        return this.menuNoSelection;
    }

    public WorkflowTab getButtonComposite() {
        return this.workflowTab;
    }
}

